const express = require("express");
const contractorRouter = express.Router();
const {
  Project,
  WindUpliftController,
  BidController,
  Contractor,
  PaymentCtr,
  Manufacturer,
  BidSubmissionCtrl,
  BidInvitationCtrl
} = require("../controllers");
const {
  ProjectController,
  ContractorConroller,
  Bid
} = require("../mobile");
const {
  validateToken,
  mustBe,
  authorization,
  validateContractor,
  session,
} = require("../middlewares/");
var multer = require("multer");
const { storage } = require("../config/multer.config");

// Multer configurations
var upload = multer({ storage: storage });

// Contractor Global middleware
contractorRouter.use([
  validateToken.verify,
  // session.isSessionActive,
  mustBe.active,
  // mustBe.contractor,
]);
const stripe = require('stripe')(process.env.STRIPE_SECURITY_KEY);


// contractorRouter.use([authorization.hasPermission]);

//Routes for Mobile app
contractorRouter.post("/tellOwner/AboutYou",upload.fields([{ name: "contractor_docs" }]),ContractorConroller.tellOwnerAboutYou);
contractorRouter.post("/bid/form",upload.fields([{ name: "contractor_docs" }]),Bid.bidForm);
contractorRouter.put("/edit/bidForm",Bid.editBidForm);
contractorRouter.get("/accept/invitation",Bid.acceptBidInvitation);
contractorRouter.post("/ask/question", ProjectController.addQuestions);
contractorRouter.get("/getAll/questionAnswers",ProjectController.viewAllQuestionsAndAnswers);
contractorRouter.get("/get/all/projects",ProjectController.projectListByUsersLocation);
contractorRouter.get("/bidden/projects",Bid.biddenprojects);
contractorRouter.get("/search/projects",ProjectController.searchProjects);
contractorRouter.get("/search/biddenProjects",Bid.searchBiddenProjects);
contractorRouter.get("/winning/projects",Bid.winningBidProjects);
contractorRouter.get("/search/wonProjects",Bid.searchWonProjects);
contractorRouter.get("/search/closedProjects",ProjectController.searchClosedProjects);
// contractorRouter.get("/get/closedProjects",ProjectController.getClosedProjects);
contractorRouter.get("/getInvitationList", Bid.getInvitationList);
contractorRouter.get('/get/biddenproject',Bid.getBidInfoById)
contractorRouter.post("/payment",PaymentCtr.makePayments);
contractorRouter.post("/payment/receipt/details",PaymentCtr.getMyTransactionDetails);
contractorRouter.get("/project/view", Project.viewOne);
contractorRouter.get("/project/view/all", Project.viewAll);
contractorRouter.get("/manufacturer/view/all", Manufacturer.viewAll);
// bid Management Routes
// contractorRouter.post("/bid/create", bidController.addBid);
// contractorRouter.get("/bid/view", bidController.viewBid); // ?id=
// contractorRouter.get("/bid/view/all", bidController.viewAll_Bid);
// contractorRouter.put("/bid/update", bidController.updateBid);
// contractorRouter.delete("/bid/delete/", bidController.deleteBid); //?id=

// New routes - Shivam
contractorRouter.get("/projects", ProjectController.getProjects);
contractorRouter.get("/project/details", ProjectController.getProjectDetails);
contractorRouter.get("/project/media", ProjectController.getProjectMedia);
contractorRouter.get("/project/notes", ProjectController.getProjectNotes);
contractorRouter.get("/project/estimatorAssistant", ProjectController.getProjectEstimatorAssistant);
contractorRouter.post("/projects/ask/question", ProjectController.submitQuestion);
contractorRouter.get("/projects/getAll/questionAnswers",ProjectController.viewAllQuestionsAndAnswers);
contractorRouter.post("/project/submitBid", BidSubmissionCtrl.submitBid);
contractorRouter.put("/project/updateBid", BidSubmissionCtrl.updateBid);
contractorRouter.get("/project/mybidDetails/:project_id", BidSubmissionCtrl.getMyBidDetails);
contractorRouter.get("/project/myBiddenProjects", ProjectController.getBiddenProjects);
contractorRouter.get("/project/getclosedProjects",ProjectController.closedProjects);
contractorRouter.get("/project/getPurchasedProjects",ProjectController.getPurchasedProjects);
contractorRouter.get("/project/getWonProjects",ProjectController.getMyWonProjects);

contractorRouter.get("/bid-invitation/list", BidInvitationCtrl.getMyInvitationRequests);
contractorRouter.post("/bid-invitation/accept", BidInvitationCtrl.acceptInvitation);
contractorRouter.post("/bid-invitation/reject", BidInvitationCtrl.rejectInvitation);



// purchase opportunity
 // Checkout Payment
 contractorRouter.post("/opportunity/payment", PaymentCtr.makePayments);
//  contractorRouter.post("/payment/webhook",express.raw({ type: 'application/json' }), PaymentCtr.onTransactionComplete);
 

module.exports = contractorRouter;