const express = require("express");
const adminRouter = express.Router();
const { validateRequest, validateToken, mustBe, validateRPC, validateOwner, validateContractor, validateRvalue, } = require("../middlewares/");
const { RPCManagement, Owner, Manufacturer, Building, Project, Contractor, RValueController, CMSPageController, FaqController, ApplicationSettingsMenuController, DashboardController, TermController, ProjectCategoryController, NotificationsCtrl, BidFormTemplateCtrl, BidSubmissionCtrl, MasterLineItemsCtrl, MasterProjectDescriptionCtrl, BidInvitationCtrl, GraphReportCtrl, SharedController } = require("../controllers");
const { ProjectController } = require('../mobile');
var multer = require("multer");
const { storage } = require("../config/multer.config");
var upload = multer({ storage: storage });

// RPC Global middleware
adminRouter.use([
    validateToken.verify,
    mustBe.active,
  ]);
// Get user permissions and module details
adminRouter.post("/users/permissions", SharedController.getuserPermission);


// RPC Management Routes
adminRouter.post("/rpc-management/create", upload.fields([{ name: "company_logo" }]),RPCManagement.addRPC);
adminRouter.get("/rpc-management/read/all", RPCManagement.getAll_RPC);
adminRouter.get("/rpc-management/getOne", RPCManagement.viewRPC);
adminRouter.put("/rpc-management/update", upload.fields([{ name: "company_logo" }]),RPCManagement.updateRPC);
adminRouter.delete("/rpc-management/delete/", RPCManagement.deleteRPC); // ?id=
adminRouter.post("/rpc-management/update/status", RPCManagement.updateRPCstatus);
adminRouter.get("/rpc-management/search", RPCManagement.searchRPCManager); //?value=
//adminRouter.post("/rpc-management/view/:id", RPCManagement.viewRPC);

// Owner Management Routes
adminRouter.post("/owner/create",upload.fields([{ name: "company_logo" }]), Owner.add);
adminRouter.get("/owner/view", Owner.viewOne); // ?id=
adminRouter.get("/owner/view/all", Owner.viewAll);
adminRouter.put("/owner/update/:id",upload.fields([{ name: "company_logo" }]), Owner.update);
adminRouter.delete("/owner/delete/", Owner.deleteOwner); //?id=
adminRouter.get("/owner/view/search", Owner.search); //?id=value
adminRouter.post("/owner/update/status/:id", Owner.updatestatus);

// Owner Management Routes
adminRouter.post("/manufacturer/create",upload.fields([{ name: "company_logo" }]), Manufacturer.add);
adminRouter.get("/manufacturer/view/all", Manufacturer.viewAll);
adminRouter.put("/manufacturer/update",upload.fields([{ name: "company_logo" }]), Manufacturer.update);
adminRouter.delete("/manufacturer/delete/", Manufacturer.deleteManufacturer); //?id=

// Building Management Routes
adminRouter.post("/building/create", upload.fields([{ name: "building_videos" }, { name: "building_images" }, { name: "building_documents" }]), Building.add);
adminRouter.get("/building/view/all", Building.viewAll);
adminRouter.get("/building/view", Building.viewOne); // ?id=value
adminRouter.put("/building/update", upload.fields([{ name: "building_videos" }, { name: "building_images" }, { name: "building_documents" }]), Building.update);
adminRouter.delete("/building/delete/", Building.deleteOne);
adminRouter.delete("/building/delete/document", Building.deleteDocument);

// Project Management Routes
adminRouter.post("/project/create", upload.fields([{ name: "roof_drawings" }, { name: "images" }, { name: "standard_contract" }, { name: "insurance" }, { name: "videos" }, { name: "detail_drawings" }, { name: "specifications" }]), Project.add);
adminRouter.get("/project/view/all", Project.viewAll);
adminRouter.get("/project/view", Project.viewOne); // /?id=
adminRouter.put("/project/update", Project.update);
adminRouter.delete("/project/delete", Project.deleteProject); //?id=
adminRouter.post("/project/addUpdateEstimator", Project.addUpdateEstimatorAssitance);
adminRouter.put("/project/bids/change-period", Project.changeBidPeriod);


// Contractor Management Routes
adminRouter.post("/contractor/create",upload.fields([{ name: "company_logo" }]), Contractor.addContractor);
adminRouter.get("/contractor/view/all", Contractor.viewAllContractor);
adminRouter.get("/contractor/view", Contractor.viewContractor); // /?id=
adminRouter.put("/contractor/update",upload.fields([{ name: "company_logo" }]), Contractor.updateContractor);
adminRouter.delete("/contractor/delete", Contractor.deleteContractor); //?id=

// RValue Management Routes
adminRouter.post("/r-value/create", [validateRvalue.addRvalue], RValueController.addRValue);
// rpcRouter.get("/r-value/view/all", RValueController.viewAllRValue);
// rpcRouter.get("/r-vlaue/view", Contractor.viewRValue); // /?id=
// rpcRouter.put("/r-value/update", Contractor.updateRValue);
adminRouter.delete("/r-value/delete", RValueController.deleteRValue); //?id=
//Question Answer Management
adminRouter.post("/post/answer", ProjectController.addAnswer);
adminRouter.get("/projects/getAll/questionAnswers", ProjectController.viewAllQuestionsAndAnswers);


// CMS Static Page Management Routes- shivam
adminRouter.post("/page/create", upload.fields([{ name: "banner_images" }]), CMSPageController.create);
adminRouter.get("/page/view/all", CMSPageController.findAll);
adminRouter.get("/page/details/:id", CMSPageController.findOne);
adminRouter.get("/page/view/:slug", CMSPageController.findPageBySlug);
adminRouter.put("/page/update", upload.fields([{ name: "banner_images" }]), CMSPageController.update);

// FAQ Routes- shivam
adminRouter.post("/faq/create", FaqController.add);
adminRouter.get("/faq/view/all", FaqController.viewAll);
adminRouter.get("/faq/view", FaqController.viewOne);
adminRouter.put("/faq/update", FaqController.update);
adminRouter.delete("/faq/delete/:id", FaqController.deleteFaq); //?id=

// Application Settings Menu Management Routes- shivam
adminRouter.post("/menu/create", ApplicationSettingsMenuController.create);
adminRouter.get("/menu/view/all", ApplicationSettingsMenuController.findAll);
adminRouter.get("/menu/details/:id", ApplicationSettingsMenuController.findOne);
adminRouter.put("/menu/update", ApplicationSettingsMenuController.update);
adminRouter.delete("/menu/delete/:id", ApplicationSettingsMenuController.deleteMenu); //?id=

// Admin Dashboard Route- shivam
adminRouter.get("/getDashboardData", DashboardController.getDashboardData);

// Project category/ Subcategory Routes- shivam
adminRouter.post("/project/category/create", ProjectCategoryController.addCategory);
adminRouter.post("/project/subcategory/create", ProjectCategoryController.addSubCategory);
adminRouter.put("/project/category/update", ProjectCategoryController.update);
adminRouter.get("/project/category/view/all", ProjectCategoryController.getAllCategories);
adminRouter.get("/project/subcategory/view/all", ProjectCategoryController.getAllSubCategories);
adminRouter.get('/project/subcategory/:cat_id', ProjectCategoryController.getSubCategoriesByCatId);
adminRouter.delete("/project/category/delete/:id", ProjectCategoryController.deleteCategory);
adminRouter.delete("/project/subcategory/delete/:id", ProjectCategoryController.deleteSubCategory);

// Broadcast Notification to users- shivam
adminRouter.post("/notifications/broadcastMessage", NotificationsCtrl.sendNotificationTousers);


// Master Line Items  Management - related to bid Form Line items Master Database 
adminRouter.get("/masterLineItems/list", MasterLineItemsCtrl.viewAll);
adminRouter.post("/masterLineItems/create", MasterLineItemsCtrl.add);
adminRouter.put("/masterLineItems/update", MasterLineItemsCtrl.updateLineItem);

// TERM Routes
adminRouter.post("/term/create", TermController.add);
adminRouter.get("/term/view/all", TermController.viewAll);
adminRouter.put("/term/update", TermController.update);
adminRouter.delete("/term/delete/:id", TermController.deleteTerm);

// Project specific Bid Form Template Routes
adminRouter.post("/project/bidForm/create", BidFormTemplateCtrl.create);
adminRouter.get("/project/viewBidForm/:project_id", BidFormTemplateCtrl.getProjectBidForm);

adminRouter.put("/project/bidForm/update", BidFormTemplateCtrl.updateBidForm);
adminRouter.get("/project/bidSubmission/list/:project_id", BidSubmissionCtrl.getAllBids);
adminRouter.post("/project/bidSubmission/award", BidSubmissionCtrl.awardBid);

// Master Project Description Management - Master project description DB
adminRouter.get("/masterProjectDescription/list", MasterProjectDescriptionCtrl.fullData);
adminRouter.get("/masterProjectDescription/list-pagination", MasterProjectDescriptionCtrl.viewAll);
adminRouter.post("/masterProjectDescription/create", MasterProjectDescriptionCtrl.add);
adminRouter.put("/masterProjectDescription/update", MasterProjectDescriptionCtrl.updateMasterProjectDescritpion);

adminRouter.post("/bid-invitation/send", BidInvitationCtrl.sendBidInvitation);
adminRouter.post("/bid-invitation/list", BidInvitationCtrl.getAllInvitationByProjectId);
adminRouter.post("/send_email_to_bidders", BidInvitationCtrl.sendEmailtoBidders);

//Graph Reports Module - Templates creation
adminRouter.post("/graph_reports/create", GraphReportCtrl.create);
adminRouter.put("/graph_reports/update", GraphReportCtrl.updateGraphTemplate);
adminRouter.get("/graph_reports/list", GraphReportCtrl.getGraphreportsTemplateList);
adminRouter.delete("/graph_reports/delete/:id", GraphReportCtrl.deleteReport); //?id=
adminRouter.post("/graph_reports/generate", GraphReportCtrl.getGraphData);



module.exports = adminRouter;
