const mongoose = require("mongoose");
const mongoosePaginate = require('mongoose-paginate-v2');
const mongooseDelete = require('mongoose-delete');

const WindUpliftSchema = new mongoose.Schema(
  {
    wind_uplift_name: {
      type: String,
      required: true,
    },
    description: {
      type: String,
      required: true,
    },
    status: {
      type: Boolean,
      default: true,
    },
    createdBy: {
      type: mongoose.Types.ObjectId,
      ref: "User",
    },
    updatedBy: {
      type: mongoose.Types.ObjectId,
      ref: "User",
    }
  },
  {
    versionKey: false,
    timestamps: true,
  }
);




WindUpliftSchema.plugin(mongoosePaginate);
WindUpliftSchema.plugin(mongooseDelete);


module.exports = mongoose.model("wind_uplift", WindUpliftSchema);;
