const mongoose = require("mongoose");
const mongoosePaginate = require('mongoose-paginate-v2');
const mongooseDelete = require('mongoose-delete');
const schema = mongoose.Schema;

const StaticPagesSchema = new schema(
  {
    building_owner_name: {
      type: String,
      required: true,
    },
    description: {
      type: String,
      required: true,
    },
    documents: 
      {
          type: {
              type: String
          },
          filename: {
              type: String
          },
          path: {
              type: String
          },
      }
  ,
    createdBy: {
      type: mongoose.Types.ObjectId,
      ref: "User",
    },
    updatedBy: {
      type: mongoose.Types.ObjectId,
      ref: "User",
    }
  },
  {
    versionKey: false,
    timestamps: true,
  }
);




StaticPagesSchema.plugin(mongoosePaginate);
StaticPagesSchema.plugin(mongooseDelete);

const StaticPages = mongoose.model("static_pages", StaticPagesSchema);

module.exports = StaticPages;
