const mongoose = require("mongoose");
const mongoosePaginate = require('mongoose-paginate-v2')
const mongooseDelete = require('mongoose-delete');

const RoofApproachSchema = new mongoose.Schema({
    name: {
        type: String
    },
    description: {
        type: String
    },
    status: {
        type: Boolean,
        default : true,
    },
    price:{
        type:Number,
        default : 0,
        unit :{
            type: String,
            default : "Per SQFT"
        }
    },
    createdBy: {
        type: mongoose.Types.ObjectId,
    },
    updatedBy: {
        type: mongoose.Types.ObjectId,
    }
},
    {
        versionKey: false,
        timestamps: true
    }
);

RoofApproachSchema.plugin(mongoosePaginate)
RoofApproachSchema.plugin(mongooseDelete);

module.exports = mongoose.model("roof_Approach", RoofApproachSchema);

