const mongoose = require("mongoose");
const mongoosePaginate = require('mongoose-paginate-v2');
const mongooseDelete = require('mongoose-delete');
const schema = mongoose.Schema;

const projectBidFormSchema = new schema(
  {
    project_id: { type: mongoose.Schema.Types.ObjectId, ref: "Project" , required:true, unique:true},
    line_items:[{
      item: {
        type: String,
        required: true,
        trim: true,
      },
      default_value: {
        type: Number,
      },
      allowed_in_words:{type: Boolean , default:false},
      is_master_lineItem:{type: Boolean , default:false}, // true is line item picked from master collection
      master_lineItem_id: { type: mongoose.Schema.Types.ObjectId, ref: "master_line_items"  }
    }], 
  },
  {
    versionKey: false,
    timestamps: true,
  }
);


const projectBidform = mongoose.model("project_bid_forms_template", projectBidFormSchema);

module.exports = projectBidform;
