const mongoose = require("mongoose");
const mongoosePaginate = require('mongoose-paginate-v2');
const mongooseDelete = require('mongoose-delete');
const schema = mongoose.Schema;

const CategorySchema = new schema(
  {
    name: {
      type: String,
      required: true,
      trim: true,
    },
    slug: {
      type: String,
      required: true,
      trim: true,
    },
    created_by: { type: mongoose.Schema.Types.ObjectId, ref: 'User' },
    parent: {
      type: mongoose.Schema.Types.ObjectId,
      default: null,
      ref: 'project_category'
    }
  },
  {
    versionKey: false,
    timestamps: true,
  }
);

CategorySchema.plugin(mongoosePaginate);
CategorySchema.plugin(mongooseDelete);

const ProjectCategory = mongoose.model("project_category", CategorySchema);

module.exports = ProjectCategory;
