const mongoose = require("mongoose");
const mongoosePaginate = require('mongoose-paginate-v2');
const mongooseDelete = require('mongoose-delete');
const schema = mongoose.Schema;

const projectBidSubmissionSchema = new schema(
  {
    project_id: { type: mongoose.Schema.Types.ObjectId, ref: "project" , required:true},
    submitted_by: { type: mongoose.Schema.Types.ObjectId, ref: "User" , required:true},
    selected_manufacturer: { type: mongoose.Schema.Types.ObjectId, ref: "User" , required:true},
    total_bid_amount: {type: Number, required: true , default: 0},
    total_bid_amount_in_words: {type: String , default: ''},
    line_items:[{
      item: {
        type: String,
        required: true,
        trim: true,
      },
      default_value: { type: Number },
      bid_amount: {type:Number, default: 0, required: true},
      allowed_in_words:{type: Boolean , default:false}
    }],
    expected_start_date: {type: Date },
    days_to_complete: {type: Number},
    bid_status: {type:String , default: 'OPEN'}, // OPEN, CLOSED,
    is_bid_winner : {type: Boolean , default:false}
  },
  {
    versionKey: false,
    timestamps: true,
  }
);

projectBidSubmissionSchema.plugin(mongoosePaginate);


const projectBidSubmission = mongoose.model("project_bids_submission", projectBidSubmissionSchema);

module.exports = projectBidSubmission;
