const mongoose = require("mongoose");
const mongoosePaginate = require("mongoose-paginate-v2");

const schema = mongoose.Schema;

const bidInvitationShcema = new schema(
  {
    project_id: {type: schema.Types.ObjectId, ref: "project", required: true},
    contractor_ids: [{
      type: mongoose.ObjectId,
      ref: 'User'
      }], // Will hold all the registered contractors email.
    not_registered_contractors: [],
    createdBy: { type: mongoose.Types.ObjectId, ref: "User"},
    invitation_title: {type: String , required: true},
    invitation_content: {type: String , required: true}
  },
  {
    versionKey: false,
    timestamps: true,
  }
);
bidInvitationShcema.plugin(mongoosePaginate);
const projectBidInvitation = mongoose.model("project_bid_invitation", bidInvitationShcema);

module.exports = projectBidInvitation;
