const mongoose = require("mongoose");
const mongoosePaginate = require('mongoose-paginate-v2');
const mongooseDelete = require('mongoose-delete');
const schema = mongoose.Schema;

const NotificationSettingsSchema = new schema(
  {
    type: {
      type: String,
      required: true,
      unique:true
    },
    title: {
      type: String,
      required: true,
    },
    enabled: {type: Boolean, default: true},
    notification_content: {type:String , required:true}
  },
  {
    versionKey: false,
    timestamps: true,
  }
);

NotificationSettingsSchema.plugin(mongoosePaginate);
NotificationSettingsSchema.plugin(mongooseDelete);

const NotificationsSettings = mongoose.model("notifications_settings", NotificationSettingsSchema);

module.exports = NotificationsSettings;
