const mongoose = require("mongoose");
const mongoosePaginate = require('mongoose-paginate-v2');
const mongooseDelete = require('mongoose-delete');
const schema = mongoose.Schema;

const NotificationSchema = new schema(
  {
    title: {
      type: String,
      required: true,
    },
    description: {
      type: String,
      required: true,
    },
    unread: {type: Boolean, default: true},
    to_user_ids: [{ type: mongoose.Types.ObjectId, ref: 'User'}],
    readby_user_ids: [{ type: mongoose.Types.ObjectId, ref: 'User'}],
    project_id: { type: mongoose.Types.ObjectId, ref: 'project'},
    notify_type: {type: String, required: true, default: 'GENERAL'} // PROJECT_ACTIVATION, BID_EXPIRE , BID_CLOSED, BID_PERIOD_CHANGED , BID_SUBMITED_ON_PROJECT , 
  },
  {
    versionKey: false,
    timestamps: true,
  }
);

NotificationSchema.plugin(mongoosePaginate);
NotificationSchema.plugin(mongooseDelete);

const Notifications = mongoose.model("notifications", NotificationSchema);

module.exports = Notifications;
