const mongoose = require("mongoose");
const mongoosePaginate = require("mongoose-paginate-v2");
const mongooseDelete = require('mongoose-delete');

const MasterLineItemsSchema = new mongoose.Schema({
    item: {
        type: String,
        required: true,
        trim: true,
    },
    default_value: {
        type: Number,
    },
    status: {
        type: Boolean,
        default: true
    }
},
    {
        versionKey: false,
        timestamps: true,
        collation: { locale: 'en' }, //mongoose 4.5 caseSensitive it will help to search & sort.
        toObject: { virtuals: true },
        toJSON: { virtuals: true },
    }
);

MasterLineItemsSchema.plugin(mongoosePaginate);
MasterLineItemsSchema.plugin(mongooseDelete);

module.exports = mongoose.model("master_line_items", MasterLineItemsSchema);;
