const mongoose = require("mongoose");
const mongoosePaginate = require('mongoose-paginate-v2');
const mongooseDelete = require('mongoose-delete');
const schema = mongoose.Schema;

const graphReportsSchema = new schema(
  {
    report_name: {type: String , required:true , trim: true},
    description: {type: String , required:true},
    type: {type: String , required:true}, //bar , line, pie
    yaxis: {type: String , required:true}, //total_cost , total_size , avg_cost , avg_size
    xaxis: {type: String , required:true}, //manufacturer , contractor , won_bids , no_of_bids
    country: {type: String},
    state: {type: String},
    city: {type: String},
    quaters: {type: String}, //Q1,Q2,Q3,Q4
    date_range: {
      start: Date,
      end: Date
    },
    selectedMenuItems: [
      {
          menu_title: { type: String, required: true}, // Menu name 
          menuId: { type: mongoose.Types.ObjectId, ref: 'application_settings_menu' },
          search_value: { type: String, required: true },
      }
  ] ,
  createdBy: { type: mongoose.Types.ObjectId, ref: 'User' },

  },
  {
    versionKey: false,
    timestamps: true,
  }
);

graphReportsSchema.plugin(mongoosePaginate);

const graphReports = mongoose.model("graph_reports_templates", graphReportsSchema);

module.exports = graphReports;
