const mongoose = require("mongoose");
const mongoosePaginate = require("mongoose-paginate-v2");
const mongooseDelete = require('mongoose-delete');

const ConvensionalBidSchema = new mongoose.Schema({
    first_name: {
        type: String,
        required: true
    },
    last_name: {
        type: String,
        required: false
    },
    email: {
        type: String,
        required: true
    },
    phone: {
        type: String
    },
    city: {
        type: String,
        required: true,
    },
    state: {
        type: String,
        required: true,
    },
    country: {
        type: String,
        required: true,
    },
    zip_code: {
        type: Number,
        required: true,
    },
    address1: {
        type: String
    },
    address2: {
        type: String
    },
    company_name: {
        type: String,
    },
    project_Id: {
        type: mongoose.Types.ObjectId,
        ref: "project"
    },
    bid_price: {
        type: Number
    },
    distance: {
        type: Number
    },
    is_oppoutunity_amount_paid: {
        type: Boolean,
    },
    is_bid_winner: {
        type: Boolean
    },
    is_invoice_generated: {
        type: Boolean
    },
    status: {
        type: Boolean,
        default: true
    },
    createdBy: {
        type: mongoose.Types.ObjectId,
        ref: "User",
    },
    updatedBy: {
        type: mongoose.Types.ObjectId,
        ref: "User",
    }
},
    {
        versionKey: false,
        timestamps: true,
        collation: { locale: 'en' }, //mongoose 4.5 caseSensitive it will help to search & sort.
        toObject: { virtuals: true },
        toJSON: { virtuals: true },
    }
);

ConvensionalBidSchema.plugin(mongoosePaginate);
ConvensionalBidSchema.plugin(mongooseDelete);

module.exports = mongoose.model("convensional_bid", ConvensionalBidSchema);;
