const mongoose = require("mongoose");
const mongoosePaginate = require('mongoose-paginate-v2');
const mongooseDelete = require('mongoose-delete');
const schema = mongoose.Schema;

const CMSPageSchema = new schema(
  {
    page_title: {
      type: String,
      required: true,
      trim: true,
      unique: true
    },
    page_content: { type: String },
    is_active: {type: Boolean, default: true},
    slug: {
      type: String,
      required: true,
      trim: true,
      unique: true
    },
    type: { type : String , defult: 'NORMAL_CONTENT'}, // type: NORMAL_CONTENT, BLOCK_CONTENT
    blocks:[{
      heading: {
        type: String,
        trim: true,
      },
      description: {
        type: String,
      },
      order_secquence:{type: Number}
    }], // Allow max only 10 blocks
    banner_images:[],
    banner_heading:{type:String, default:''},
    banner_description:{type:String, default:''}
  },
  {
    versionKey: false,
    timestamps: true,
  }
);




CMSPageSchema.plugin(mongoosePaginate);
CMSPageSchema.plugin(mongooseDelete);

const OwnerType = mongoose.model("cms_pages", CMSPageSchema);

module.exports = OwnerType;
