const mongoose = require("mongoose");
const mongoosePaginate = require("mongoose-paginate-v2");

const UserPermissionSchema = new mongoose.Schema(
  {
    user_id: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "User"
    },
    module: [{ type: String }],
  },
  {
    versionKey: false,
    timestamps: true,
  }
);

UserPermissionSchema.plugin(mongoosePaginate);
module.exports = mongoose.model("UserPermission", UserPermissionSchema);
