const mongoose = require("mongoose");
const mongoosePaginate = require('mongoose-paginate-v2')
const mongooseDelete = require('mongoose-delete');

const userSchema = new mongoose.Schema({
    first_name: {
        type: String,
        required: true,
    },
    last_name: {
        type: String
    },
    email: {
        type: String,
        required: true,
        match: /.+\@.+\..+/,
        lowercase: true,
        unique: true
    },
    password: {
        type: String
    },
    otp: {
        type: String
    },
    mobile_no: {
        type: Number,
        required: true,
    },
    phone_no: {
        type: Number,
    },
    toll_free_no: {
        type: Number,
    },
    city: {
        type: String,
        required: true,
    },
    state: {
        type: String,
        required: true,
    },
    country: {
        type: String,
        required: true,
    },
    zip_code: {
        type: Number,
        required: true,
    },
    company_name: {
        type: String,
    },
    status: {
        type: Boolean,
        default: 1
    },
    profile_url: {
        type: String,
    },
    profile_pic: {
        type: {
            type: String, default: ""
        },
        filename: {
            type: String, default: ""
        },
        path: {
            type: String, default: ""
        },
    },
    address1: {
        type: String,
    },
    address2: {
        type: String,
    },
    role: {
        type: String,
        ref: "Role"
    },
    token: {
        type: String
    },
    verification: {
        type: String
    },
    owner_type: {
        type: String
    },
    createdBy: {
        type: mongoose.Types.ObjectId,
    },
    updatedBy: {
        type: mongoose.Types.ObjectId,
    },
    password_change_required: { type: Boolean, default: true },
    user_id: { type: String, required: true, unique:true },
    company_logo: {type: String, default: ""},
    purchased_opportunities: [{ type: mongoose.Schema.Types.ObjectId, ref: 'project' }], // project object ID ref - purchased by user

},
    {
        versionKey: false,
        timestamps: true,
        toObject: { virtuals: true },
        toJSON: { virtuals: true },
        collation: { locale: 'en' } //mongoose 4.5 caseSensitive it will help to search & sort.
    }
);

userSchema.plugin(mongoosePaginate)
userSchema.plugin(mongooseDelete);

userSchema.virtual('assign', {
    ref: 'UserPermission',
    localField: '_id',
    foreignField: 'user_id',
    justOne: true
});

userSchema.virtual('total_buildings', {
    ref: 'Building',
    localField: '_id',
    foreignField: 'ownerId',
    count: true
});

userSchema.virtual('buildings', {
    ref: 'Building',
    localField: '_id',
    foreignField: 'ownerId',
});
userSchema.virtual('media', {
    ref: 'Media',
    localField: '_id',
    foreignField: 'ref_id'
});
userSchema.virtual('bid', {
    ref: 'Bid',
    localField: '_id',
    foreignField: 'contractor_id'
});
module.exports = mongoose.model("User", userSchema);;


