const mongoose = require("mongoose");
const mongoosePaginate = require("mongoose-paginate-v2");

const schema = mongoose.Schema;

const transactions = new schema(
    {
        project_id: {
            type: mongoose.Types.ObjectId,
            required: true,
        },
        bid_id: {
            type: mongoose.Types.ObjectId,
            required: true,
        },
        transaction_id: {
            type: String,
            required: true,
        },
        amount: {
            type: Number,
            required: true
        },
        mode: {
            type: String,
            required: false
        },
        createdBy: {
            type: mongoose.Types.ObjectId,
            ref: "User",
            required: true
        },
        createdAt: {
            type: Date,
            default: Date.now,
        },
        updatedAt: {
            type: Date,
            default: Date.now,
        },
    },
    {
        versionKey: false,
        timestamps: true,
    }
);
transactions.plugin(mongoosePaginate);
const transaction = mongoose.model("transaction", transactions);

module.exports = transaction;
