const mongoose = require("mongoose");
const mongoosePaginate = require('mongoose-paginate-v2');
const mongooseDelete = require('mongoose-delete');

const schema = mongoose.Schema;


const termSchema = new schema({
    title: {
        type: String,
        required: true,
    },
    detail: {
        type: String,
        required: true
    },
    status:
        { type: Boolean, default: true },
},
    {
        versionKey: false,
        timestamps: true,
    }
);

termSchema.plugin(mongoosePaginate);
termSchema.plugin(mongooseDelete);

const Terms = mongoose.model("Terms", termSchema);

module.exports = Terms;
