const mongoose = require("mongoose");
//const mongoosePaginate = require("mongoose-paginate-v2");

const schema = mongoose.Schema;

const oneDay = 1000 * 60 * 60 * 24;

const sessionSchema = new schema({
  user_id: {
    type: schema.Types.ObjectId,
    ref: "User",
    required: true,
  },
  is_active:{
    type: Boolean,
    default:true
  },
  createdAt: {
    type: Date,
    default: Date.now,
    expires:`${oneDay}`
  },
});
const session = mongoose.model("session", sessionSchema);

module.exports = session;
