const mongoose = require("mongoose");
const mongoosePaginate = require('mongoose-paginate-v2');
const mongooseDelete = require('mongoose-delete');

const questionAnswersSchema = new mongoose.Schema(
    {
        question_text: {type:String, required:true, trim: true},
        answer_text: {type:String, default:"", trim: true},
        created_by: { type: mongoose.Schema.Types.ObjectId, ref: "User"},
        replied_by: { type: mongoose.Schema.Types.ObjectId, ref: "User"},
        publish_status: { type: Boolean , default: true},
        project_id: { type: mongoose.Schema.Types.ObjectId, ref: "Project" , required:true}
    },
    {
        versionKey: false,
        timestamps: true,
        collation: { locale: 'en' }, //mongoose 4.5 caseSensitive it will help to search & sort.
        toObject: { virtuals: true },
        toJSON: { virtuals: true },
    }
);

questionAnswersSchema.plugin(mongoosePaginate);
questionAnswersSchema.plugin(mongooseDelete);

module.exports = mongoose.model("project_questions", questionAnswersSchema);