const mongoose = require("mongoose");
const mongoosePaginate = require('mongoose-paginate-v2');
const mongooseDelete = require('mongoose-delete');

const projectSchema = new mongoose.Schema(
    {
        project_title: { type: String, required: true },
        ownerId: { type: mongoose.Types.ObjectId, ref: "User" },
        building_type: { type: String },
        buildingId: { type: mongoose.Types.ObjectId, ref: 'Building' },
        city: { type: String, required: true, default: '' },
        state: { type: String,required: true, default: '' },
        country: { type: String, required: true, default: '' },
        address: { type: String,required: true, default: '' },
        zip_code: { type: Number, required: true, default: '' },
        loc: { type: { type: String, enum: 'Point', default: 'Point' }, coordinates: { type: [Number], default: [0, 0] } },
        lattitude: { type:  Number , default: 0},
        longitude: { type:  Number , default: 0},
        start_date: { type: Date },
        end_date: { type: Date },
        status: { type: Boolean, default: true },
        description: { type: String },
        notes: { type: String },
        estimatorAssistance: { type: String },
        price: { type: Number },
        documents: [
            {
                file_id: { type: mongoose.Types.ObjectId, ref: "File" }
            }
        ],
        square_footage: { type: Number },
        existingRoof_type: { type: mongoose.Schema.Types.ObjectId, ref: "roof_type" },
        newRoof_type: { type: mongoose.Schema.Types.ObjectId, ref: "new_roof_type" },
        roof_layer: { type: String },
        reRoofApproach: { type: String },
        localContractors: { type: String },
        union: { type: String },
        qtr_bidding: { type: String },
        roof_section: { type: String },
        penetration_Density: { type: String },
        roof_access: { type: String },
        stories: { type: String },
        project_status: { type: String , default:'open'}, //open, close all smallcase
        decendingTime: { type: String },
        timeZone: { type: String },
        material_type: { type: mongoose.Schema.Types.ObjectId, ref: "material_type" },
        r_value: { type: mongoose.Schema.Types.ObjectId, ref: "RValue" },
        wind_uplift: { type: mongoose.Schema.Types.ObjectId, ref: "wind_uplift" },
        manufacturers: { type: [], ref: "User" },
        bid_period: { type: Date },
        site_visit: { type: String },
        tear_off: { type: Boolean, default: false }, // true = Yes false = overlay
        waranty: { type: String },
        deck_type: { type: String },
        project_notes: { type: String },
        owner_requirment_bid: {
            type: String
        },
        RCAcceptanceForm: { type: String },
        BidActivity: { uid: { type: String }, date: { type: Date, default: Date.now } },
        Questions: { type: String },
        bidder: [{
                    contractorId: { type: mongoose.Types.ObjectId, ref: 'User' },
                    date: { type: Date, default: Date.now }, time: { type: Date, default: Date.now }
                }],
        selectedMenuItems: [
            {
                options: [],
                menu_title: { type: String, required: true}, // Menu name 
                menuId: { type: mongoose.Types.ObjectId, ref: 'application_settings_menu' },
                type: { type: String, required: true }, // textarea, boolean,range, dropdown, multi-dropdown
                selectedOptions: [], // only push the values of user's selected dropdown option's data ( string text only ). ex: a) Multi select ['MALE' , 'FEMALE'] , b) single select ['MALE'] c) Textarea ['This is my Long text area input value entred by user for menu type TEXTAREA']
                min_value: { type: Number, default: 0 },  // will only have values when type is range
                max_value: { type: Number, default: 0 },  // will only have values when type is range
            }
        ],
        associatedEstimatorAssistance:[
            {
                _id:{type: mongoose.Types.ObjectId},
                title:{type:String},
                description:{type:String},
            }
        ],
        projectDescription:[
            {
                _id:{type: mongoose.Types.ObjectId},
                title:{type:String},
                description:{type:String},
                is_master: {type: Boolean , default: 'false'}
            }
        ],
        bid_start_date : { type: Date },
        bid_end_date : { type: Date },
        bidder_fee: { type: Number },
        winners_bidder_fee: { type: Number , default:0.0},
        allowedBid: { type: [] },
        bids_submission: [{
            type: mongoose.ObjectId,
            ref: 'project_bids_submission'
          }],
        participating_bidders: [{
        type: mongoose.ObjectId,
        ref: 'User'
        }],
        transaction_ids: [{
            type: mongoose.ObjectId,
            ref: 'opportunityPayment'
            }],
        
        approach_type: { type: String, default: '' }, // overlay, tear-off, coated
        
        createdBy: { type: mongoose.Types.ObjectId, ref: "User" },
        updatedBy: { type: mongoose.Types.ObjectId, ref: "User" }
    },
    {
        versionKey: false,
        timestamps: true,
        collation: { locale: 'en' }, //mongoose 4.5 caseSensitive it will help to search & sort.
        toObject: { virtuals: true },
        toJSON: { virtuals: true },
    }
);

projectSchema.virtual('media', {
    ref: 'Media',
    localField: '_id',
    foreignField: 'ref_id'
});

projectSchema.virtual('bids', {
    ref: 'bid',
    localField: '_id',
    foreignField: 'project_Id'
});

projectSchema.virtual('inspection', {
    ref: 'inspection',
    localField: '_id',
    foreignField: 'projectId'
});

// projectSchema.virtual('estimator', {
//     ref: 'estimator_assistance',
//     localField: '_id',
//     foreignField: 'projectId'
// });

projectSchema.plugin(mongoosePaginate);
projectSchema.plugin(mongooseDelete);

module.exports = mongoose.model("project", projectSchema);