const mongoose = require("mongoose");
const mongoosePaginate = require('mongoose-paginate-v2');
const mongooseDelete = require('mongoose-delete');
const schema = mongoose.Schema;

const OwnerTypeSchema = new schema(
  {
    owner_type_name: {
      type: String,
      required: true,
    },
    description: {
      type: String,
      required: true,
    },
    status: {
      type: Boolean,
      default: 1,
    },
    createdBy: {
      type: mongoose.Types.ObjectId,
      ref: "User",
    },
    updatedBy: {
      type: mongoose.Types.ObjectId,
      ref: "User",
    }
  },
  {
    versionKey: false,
    timestamps: true,
  }
);




OwnerTypeSchema.plugin(mongoosePaginate);
OwnerTypeSchema.plugin(mongooseDelete);

const OwnerType = mongoose.model("owner_type", OwnerTypeSchema);

module.exports = OwnerType;
