const mongoose = require("mongoose");
const mongoosePaginate = require("mongoose-paginate-v2");

const schema = mongoose.Schema;

const OpportunityPayment = new schema(
    {
        project_id: { type: mongoose.Types.ObjectId, ref: "project", required: true},
        session_id: {type: String,required: true},
        purchasedBy: { type: mongoose.Types.ObjectId, ref: "User", required: true },
        
        transaction_id: {type: String,required: true},
        client_reference_id: {type: String,required: true},

        amount: {type: Number, required: true},
        currency: {type : String, required: true},
        mode: {type: String, required: true},

        payment_status: { type: String , required: true },
        metadata : { type: Object , required: true },
        gateway_response: { type: Object, required: true }
    },
    {
        versionKey: false,
        timestamps: true,
    }
);
OpportunityPayment.plugin(mongoosePaginate);
const opportunityPayment = mongoose.model("opportunityPayment", OpportunityPayment);

module.exports = opportunityPayment;
