const mongoose = require("mongoose");
const mongoosePaginate = require('mongoose-paginate-v2')
const mongooseDelete = require('mongoose-delete');

const NewRoofTypeSchema = new mongoose.Schema(
  {
    roof_type_name: {
      type: String,
      required: true,
    },
    price: {
      type: Number
    },
    description: {
      type: String,
      required: true,
    },
    status: {
      type: Boolean
    },
    createdBy: {
      type: mongoose.Types.ObjectId,
      ref: "User",
    },
    updatedBy: {
      type: mongoose.Types.ObjectId,
      ref: "User",
    }
  },
  {
    versionKey: false,
    timestamps: true,
  }
);

NewRoofTypeSchema.plugin(mongoosePaginate)
NewRoofTypeSchema.plugin(mongooseDelete);

module.exports = mongoose.model("new_roof_type", NewRoofTypeSchema);

