const mongoose = require("mongoose");
const mongoosePaginate = require("mongoose-paginate-v2");
const mongooseDelete = require('mongoose-delete');
const ModuleSchema = new mongoose.Schema(
  {
    name: {
      type: String,
      required: true
    },
    childrens: [{
      _id: { type: mongoose.Types.ObjectId },
      name: { type: String },
      icon: { type: Object },
      link: { type: String },
      render_key: { type: Number }
    }],
    icon: {
      type: Object,
    },
    link: {
      type: String,
    },
    lock: { // use for lock module unable to delete after final changes
      type: Boolean,
      default: false
    },
    status: {
      type: Boolean,
      default: true
    },
    render_key: {
      type: Number,
      required: true
    }
  },
  {
    versionKey: false,
    timestamps: true,

  }
);


ModuleSchema.plugin(mongoosePaginate);
module.exports = mongoose.model("Module", ModuleSchema);
