const mongoose = require("mongoose");
const mongoosePaginate = require('mongoose-paginate-v2');
const mongooseDelete = require('mongoose-delete');

const MediaSchema = new mongoose.Schema({
    type: {
        type: String
    },
    filename: {
        type: String
    },
    path: {
        type: String
    },
    ref_id: {
        type: mongoose.Types.ObjectId,
    }
}, {
    versionKey: false,
    timestamps: true,
});

MediaSchema.plugin(mongoosePaginate);
MediaSchema.plugin(mongooseDelete);

module.exports = mongoose.model("Media", MediaSchema);