const mongoose = require("mongoose");
const mongoosePaginate = require('mongoose-paginate-v2')
const mongooseDelete = require('mongoose-delete');

const MaterialTypeSchema = new mongoose.Schema(
  {
    material_name: {
      type: String,
      required: true,
    },
    material_type: {
      type: String,
      required: true,
    },
    price: {
      type: Number
    },
    description: {
      type: String,
      required: true,
    },
    status: {
      type: Boolean
    },
    createdBy: {
      type: mongoose.Types.ObjectId,
      ref: "User",
    },
    updatedBy: {
      type: mongoose.Types.ObjectId,
      ref: "User",
    }
  },
  {
    versionKey: false,
    timestamps: true,
  }
);

MaterialTypeSchema.plugin(mongoosePaginate)
MaterialTypeSchema.plugin(mongooseDelete);

module.exports = mongoose.model("material_type", MaterialTypeSchema);

