const mongoose = require("mongoose");
const mongoosePaginate = require("mongoose-paginate-v2");
const mongooseDelete = require('mongoose-delete');

const MasterProjectSchema = new mongoose.Schema({
    title: {
        type: String
    },
    description: {
        type: String
    },
    status: {
        type: Boolean,
        default: true
    }
},
    {
        versionKey: false,
        timestamps: true,
        collation: { locale: 'en' }, //mongoose 4.5 caseSensitive it will help to search & sort.
        toObject: { virtuals: true },
        toJSON: { virtuals: true },
    }
);

MasterProjectSchema.plugin(mongoosePaginate);
MasterProjectSchema.plugin(mongooseDelete);

module.exports = mongoose.model("master_project_description", MasterProjectSchema);;
