const mongoose = require("mongoose");
const mongoosePaginate = require('mongoose-paginate-v2');
const mongooseDelete = require('mongoose-delete');

const inspectionSchema = new mongoose.Schema(
    {
        inspector_name: {
            type: String,
            required: true,
        },
        projectId: {
            type: mongoose.Schema.Types.ObjectId,
            ref: "project",
        },
        date: {
            type: Date,
        },
        documents: [
            {
                type: {
                    type: String
                },
                filename: {
                    type: String
                },
                path: {
                    type: String
                },
            }
        ],
        remark: {
            type: String,
            required: true
        },
        city: {
            type: String,
            default: ""
        },
        state: {
            type: String,
            default: ""
        },
        country: {
            type: String,
            default: ""
        },
        zip_code: {
            type: Number,
            default: ""
        },
    },
    {
        versionKey: false,
        timestamps: true,
    }
);

inspectionSchema.plugin(mongoosePaginate);
inspectionSchema.plugin(mongooseDelete);

module.exports = mongoose.model("inspection", inspectionSchema);;
