const mongoose = require("mongoose");
const mongoosePaginate = require('mongoose-paginate-v2');
const mongooseDelete = require('mongoose-delete');
const schema = mongoose.Schema;

const FaqSchema = new schema(
  {
    faq_question: {
      type: String,
      required: true,
    },
    faq_answer: {
      type: String,
      required: true,
    },
    status: {type: Boolean, default: true},
  },
  {
    versionKey: false,
    timestamps: true,
  }
);

FaqSchema.plugin(mongoosePaginate);
FaqSchema.plugin(mongooseDelete);

const OwnerType = mongoose.model("faq", FaqSchema);

module.exports = OwnerType;
