const mongoose = require("mongoose");
const mongoosePaginate = require("mongoose-paginate-v2");
const mongooseDelete = require('mongoose-delete');

const EstimatorSchema = new mongoose.Schema({
    title: {
        type: String
    },
    description: {
        type: String
    },
    projectId: {
        type: mongoose.Types.ObjectId,
        ref: "project",
    },
    status: {
        type: Boolean,
        default: true
    },
    createdBy: {
        type: mongoose.Types.ObjectId,
        ref: "User",
    },
    updatedBy: {
        type: mongoose.Types.ObjectId,
        ref: "User",
    }
},
    {
        versionKey: false,
        timestamps: true,
        collation: { locale: 'en' }, //mongoose 4.5 caseSensitive it will help to search & sort.
        toObject: { virtuals: true },
        toJSON: { virtuals: true },
    }
);

EstimatorSchema.plugin(mongoosePaginate);
EstimatorSchema.plugin(mongooseDelete);

module.exports = mongoose.model("estimator_assistance", EstimatorSchema);;
