const mongoose = require("mongoose");
const mongoosePaginate = require('mongoose-paginate-v2');
const mongooseDelete = require('mongoose-delete');
const schema = mongoose.Schema;

const buildingTypeSchema = new schema(
  {
    building_type_name: {
      type: String,
      required: true,
    },
    description: {
      type: String,
      required: true,
    },
    createdBy: {
      type: mongoose.Types.ObjectId,
      ref: "User",
    },
    updatedBy: {
      type: mongoose.Types.ObjectId,
      ref: "User",
    },
    status: {
      type: Boolean,
      default: 1,
    }
  },
  {
    versionKey: false,
    timestamps: true,
  }
);




buildingTypeSchema.plugin(mongoosePaginate);
buildingTypeSchema.plugin(mongooseDelete);

const BuildingType = mongoose.model("building_type", buildingTypeSchema);

module.exports = BuildingType;
