const mongoose = require("mongoose");
const mongoosePaginate = require('mongoose-paginate-v2');
const mongooseDelete = require('mongoose-delete');

const buildingSchema = new mongoose.Schema(
  {
    name: {
      type: String,
      required: true,
    },
    ownerId: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "User",
    },
    building_type: {
      type: String,
    },
    address1: {
      type: String,
      required: true,
    },
    address2: {
      type: String
    },
    city: {
      type: String,
    },
    state: {
      type: String,
    },
    country: {
      type: String,
    },
    zip_code: {
      type: Number
    },
    lattitude: { type:  Number , default: 0},
    longitude: { type:  Number , default: 0},
    actual_size: {
      type: Number
    },
    size:
    {
      range: {
        type: String,
      },
      unit: {
        type: String,
        default: "sqft",
      }
    },
    status: {
      type: Boolean,
      default: true,
    },
    createdBy: {
      type: mongoose.Types.ObjectId,
      ref: "User",
    },
    updatedBy: {
      type: mongoose.Types.ObjectId,
      ref: "User",
    }
  },
  {
    versionKey: false,
    timestamps: true,
    collation: { locale: 'en' }, //mongoose 4.5 caseSensitive it will help to search & sort.
    toObject: { virtuals: true },
    toJSON: { virtuals: true },
  }
);

buildingSchema.virtual('media', {
  ref: 'Media',
  localField: '_id',
  foreignField: 'ref_id'
});

buildingSchema.virtual('projects', {
  ref: 'project',
  localField: '_id',
  foreignField: 'buildingId'
});

buildingSchema.plugin(mongoosePaginate);
buildingSchema.plugin(mongooseDelete);

module.exports = mongoose.model("Building", buildingSchema);
