const mongoose = require("mongoose");
const mongoosePaginate = require("mongoose-paginate-v2");

const schema = mongoose.Schema;

const bidInvitationShcema = new schema(
  {
    project_Id: {
      type: schema.Types.ObjectId,
      ref: "project",
      required: true,
    },
    contarctor_email: [String],
    bid_start: { type: Date, required: true },
    bid_end: { type: Date, required: true },
    timezone: { type: String, required: true },
    createdBy: {
      type: mongoose.Types.ObjectId,
      ref: "User",
    },
    bid_acceptance:{ type: Boolean, default:false },
    updatedBy: {
      type: mongoose.Types.ObjectId,
      ref: "User",
    },
    createdAt: {
      type: Date,
      default: Date.now,
    },
    updatedAt: {
      type: Date,
      default: Date.now,
    },
  },
  {
    versionKey: false,
    timestamps: true,
  }
);
bidInvitationShcema.plugin(mongoosePaginate);
const invitation = mongoose.model("invitation", bidInvitationShcema);

module.exports = invitation;
