const mongoose = require("mongoose");
const mongoosePaginate = require("mongoose-paginate-v2");

const bidSchema = new mongoose.Schema({
  project_Id: {
    type: mongoose.Types.ObjectId,
    ref: "project",
    required: false
  },
  contractor_id: {
    type: mongoose.Types.ObjectId,
    ref: "User",
    required: false
  },
  contarctor_name: {
    type: String,
    required: false
  },
  bid_price: {
    type: Number,
    required: false
  },
  distance: {
    type: Number,
    required: false

  },
  Location: {
    type: String,
    required: false
  },
  details: {
    type: String,
    required: false
  },
  company_name: {
    type: String,
    required: false
  },
  company_description: {
    type: String,
    required: false
  },
  is_oppoutunity_amount_paid: {
    type: Boolean,
  },
  isDirectEntry: {
    type: Boolean,
    default: false,
    required: false
  },
  transaction: {
    type: mongoose.Types.ObjectId
  },
  deleted: {
    type: Boolean,
    default: false,
  },
  LSBidPriceWords: {
    type: String
  },
  LSBidPriceNumber: {
    type: Number
  },
  bidPrice: {
    type: Number
  },
  unitPrice: {
    type: Number
  },
  alternateBidPriceWord: {
    type: String
  },
  alternateBidPrice: {
    type: Number
  },
  alternateUnitPrice: {
    type: Number
  },
  winningBidderPrice: {
    type: Number
  },
  totalBidPrice: {
    type: Number
  },
  is_bid_winner: {
    type: Boolean,
    default: false
  },
  is_invoice_generated: {
    type: Boolean,
    default: false
  },
  createdBy: {
    type: mongoose.Types.ObjectId,
    ref: "User",
  },
  updatedBy: {
    type: mongoose.Types.ObjectId,
    ref: "User",
  }
},
  {
    versionKey: false,
    timestamps: true,
    collation: { locale: 'en' }, //mongoose 4.5 caseSensitive it will help to search & sort.
    toObject: { virtuals: true },
    toJSON: { virtuals: true },
  }
);
bidSchema.virtual('media', {
  ref: 'Media',
  localField: '_id',
  foreignField: 'ref_id'
});

bidSchema.plugin(mongoosePaginate);

module.exports = mongoose.model("bid", bidSchema);;
