const mongoose = require("mongoose");
const mongoosePaginate = require('mongoose-paginate-v2');
const mongooseDelete = require('mongoose-delete');
const schema = mongoose.Schema;

const ApplicationSettingMenuSchema = new schema(
  {
    menu_title: {type: String, required: true, unique: true}, // Menu name 
    type:{type: String, required: true }, // textarea, boolean,range, dropdown, multi-dropdown
    key:{type: String, required: true, unique: true }, // unique text string identifier for a single menu item
    description:{type: String, default: ''}, // description of a menu item
    status: {type: Boolean,default: 1}, // for menu Active or Deactive
    defaultValue:{type: String}, // Will have value only for type TextArea
    options:[], // will be use to hold values of type single select & multiple select dropdown options.
    min_value:{type:Number, default: 0},  // will only have values when type is range
    max_value:{type:Number, default: 0},  // will only have values when type is range
    createdBy: {type: mongoose.Types.ObjectId,ref: "User"},
    updatedBy: {type: mongoose.Types.ObjectId,ref: "User"}
  },
  {
    versionKey: false,
    timestamps: true,
  }
);

ApplicationSettingMenuSchema.plugin(mongoosePaginate);
ApplicationSettingMenuSchema.plugin(mongooseDelete);

const ApplicationSetting = mongoose.model("application_settings_menu", ApplicationSettingMenuSchema);

module.exports = ApplicationSetting;

// Single / Multi drop down
// options: [
//   {
//     key: 'Option1',
//     value: '',
//     selected: false
//   },
//   {
//     key: 'Option2',
//     value: '',
//     selected: true
//   },
//   {
//     key: 'Option3',
//     value: '',
//     selected: true
//   }
// ]

// Boolean
// options: [
//   {
//     key: 'NO',
//     value: '',
//     selected: false
//   },
//   {
//     key: 'YES',
//     value: '',
//     selected: true
//   }
// ]
