const response = require("../../constants/response");
const MESSAGE = require("../../constants/message");
const EMAIL_TEMPLATES = require("../../constants/email_templates_id");
const mail = require("../../utils/notify");

const { Project, File, User, Building,QuestionAnswers, Media, Bid, projectBidSubmission} = require("../../models");
const db = require("../../services/db")
const { getLoggedInUser } = require("../../utils/jwtToken");

const addQuestions = async (req, res) => {
    try {
        const timeElapsed = Date.now();
        const today = new Date(timeElapsed);
        const user = await User.findOne({_id:req.id});
        const userId =user._id;
        const userName = user.first_name+" "+user.last_name;
        const addQuestion = new QuestionAnswers(
            {
                user_name:userName, 
                text:req.body.questionText,
                created_at:today,
                created_by:userId,
                project_id:req.body.projectId,
                is_question:true
            });
        addQuestion.save();
        if (addQuestion)
            return response.successResponse(res, 200, addQuestion, MESSAGE.QUESTION_POSTED);
        else
            return response.badRequest(res, 400, MESSAGE.QUESTION_NOT_POSTED);
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
}

// const addAnswer = async (req, res) => {
//     try {
//         const timeElapsed = Date.now();
//         const today = new Date(timeElapsed);
//         const user = await User.findOne({_id:req.id});
//         const userId =user._id
//         const userName = user.first_name+" "+user.last_name;
//         const replyData = new QuestionAnswers(
//             {
//                 user_name:userName, 
//                 text:req.body.replyText,
//                 created_at:today,
//                 created_by:userId,
//                 project_id:req.body.projectId,
//                 is_question:false
//             });
//         replyData.save();
//         const update = {reply_id:replyData._id}
//         const filter = {_id:req.body.questionId};
//         let addReplyId = await QuestionAnswers.findOneAndUpdate(filter, {$set:update},{new:true,upsert:true});
//         if (addReplyId)
//         return response.successResponse(res, 200, replyData, MESSAGE.ANSWER_POSTED);
//     else
//         return response.badRequest(res, 400, MESSAGE.ANSWER_NOT_POSTED);
//     } catch (e) {
//         return response.somethingErrorMsgResponse(res, 500, e);
//     }
// }

// Mobile API Searches List of Projects by Title
const searchProjects = async (req, res) => {
    try {
        const filter = {_id:req.id}
        const userData = await User.findOne(filter);
        let userCity = userData.city;
        let payload = req.query.payload.trim();
        let result = await Building.find({city:{'$regex': userCity,$options:'i'}});
        let arr = [];
        result.forEach(e => {
            arr.push(e._id);
        })
        let search = await Project.find({'buildingId':{$in:arr},"project_title": { $regex: '^.*' + payload, $options: 'i' }})
        .populate([{ path: 'media' }, { path: 'buildingId' }]);
        //Limit search result to 10
        search = search.slice(0, 10);
        if(search.length <= 0)
            return response.successResponse(res, 200,{}, MESSAGE.PROJECT_NOT_FOUND);
        else
            return response.successResponse(res, 200, {payload: search}, MESSAGE.PROJECT_VIEW_DATA);
    } catch (error) {
        return response.somethingErrorMsgResponse(res, 500, error);
    }
}
//
//Mobile API for getting closed projects
const getClosedProjects = async (req,res) => {
    try {
        const userData = await User.find({_id:req.id});
        let userCity = userData[0].city;
        let result = await Building.find({city:{'$regex': userCity,$options:'i'}})
        let arr = [];
        result.forEach(e => {
            arr.push(e._id);
        })
        let closedprojects = await Project.find({'buildingId':{$in:arr},project_status:"close"})
            .populate([{ path: 'media' },{path:'buildingId'}]);
        if(closedprojects.length <= 0)
        return response.successResponse(res, 200,{}, MESSAGE.PROJECT_NOT_FOUND);
        else
            return response.successResponse(res, 200, closedprojects, MESSAGE.CONTRACTOR_CLOSED_PROJECTS)
    } catch(error) {
        return response.somethingErrorMsgResponse(res, 500, error);
    }
}
// Mobile API for searching Closed projects
const searchClosedProjects = async (req,res) => {
    try {
        const userData = await User.findOne({_id:req.id});
        let userCity = userData.city;
        let result = await Building.find({city:{'$regex': userCity,$options:'i'}})
        let arr = [];
        result.forEach(e => {
            arr.push(e._id);
        })
        let payload = req.query.payload.trim();
        let search = await Project.find({$and: [{'buildingId':{$in:arr},project_status:"close","project_title": { $regex: '^.*' + payload, $options: 'i' }}]})
         .populate([{ path: 'media' },{path:'buildingId'}]);
        search = search.slice(0, 10);
        if(search.length <= 0)
            return response.successResponse(res, 200,{}, MESSAGE.PROJECT_NOT_FOUND);
        else
            return response.successResponse(res, 200, {payload:search}, MESSAGE.CONTRACTOR_CLOSED_PROJECTS)
    } catch(error) {
        return response.somethingErrorMsgResponse(res, 500, error);
    }
}

//Mobile api for getting new projects according to users city.
const projectListByUsersLocation = async (req,res) => {
try{
        const userData = await User.findOne({_id:req.id});
        let userCity = userData.city;
        let result = await Building.find({city:{'$regex': userCity,$options:'i'}})
        let arr = [];
            result.forEach(e => {
                arr.push(e._id);
            })
        let projects = await Project.find({'buildingId':{$in:arr}})
        .populate([{ path: 'media' },{ path: 'buildingId' }]).sort({createdAt:-1});
        if(projects.length <= 0)
            return response.successResponse(res, 200,{}, MESSAGE.PROJECT_NOT_FOUND);
        else
            return response.successResponse(res, 200, projects, MESSAGE.PROJECT_VIEW_DATA);
    } catch(error) {
        return response.somethingErrorMsgResponse(res, 500, error);
    }
}
// New Methods created by Shivam Mohan
const getProjects = async (req, res) =>{
    try {
        let query = await db.checkQueryString(req.query)
        query.project_status = 'open';
        query.status = true ;
        req.populate = [{ path: 'media', match: { deleted: false }, }, { path: 'ownerId' }, { path: "buildingId" }, { path: "inspection" }]
        return response.successResponse(res, 200, await db.getItems(req, Project, query), MESSAGE.PROJECT_VIEW_DATA);
    } catch (error) {
        return response.somethingErrorMsgResponse(res, 500, error);
    }
}

const getProjectDetails = async (req, res) => {

    if(!req.query.id){
        return response.badRequest(res, 500, "Please select any project to see the details. Please provide project reference id.");
    }
    console.log("req.query", req.query)
    Project.findById(req.query.id)
        .populate({
            path: 'ownerId',
            select: ['first_name', 'last_name', 'email']
        })
        .populate({
            path: 'material_type'
        })
        .populate({
            path: 'wind_uplift'
        })
        .populate({
            path: 'r_value'
        })
        .populate({
            path: 'newRoof_type'
        })
        .populate({
            path: 'existingRoof_type'
        })
        .then(projectdata => {
            if (!projectdata) {
                return response.badRequest(res, 400, "Project not found with id " + req.query.id);
            }
            console.log("rwspn", projectdata)
            //All good User has access to view project details
            return response.successResponse(res, 200, projectdata, MESSAGE.PROJECT_VIEW_DATA);
        }).catch(err => {
            console.log("err", err)
            if (err.kind === 'ObjectId') {
                return response.badRequest(res, 400, "Project Details not found.");
            }
            return response.badRequest(res, 500, "Error While fetching project details. Project Details not found.");
        });
}

const getProjectMedia = async (req, res) => {

    if(!req.query.id){
        return response.badRequest(res, 500, "Please select any project to see the details. Please provide project reference id.");
    }
    if(!req.query.type){
        return response.badRequest(res, 500, "Please provide type of media");
    }

    console.log("req.query", req.query)
    var filter = {ref_id: req.query.id , type: req.query.type,deleted:false }
    Media.find(filter)
        .then(projectdata => {
            if (!projectdata) {
                return response.badRequest(res, 400, "Media details not found with id " + req.query.id);
            }
            console.log("rwspn", projectdata)
            //All good User has access to view project details
            return response.successResponse(res, 200, projectdata, "Project "+ req.query.type +" reterived successfully.");
        }).catch(err => {
            console.log("err", err)
            if (err.kind === 'ObjectId') {
                return response.badRequest(res, 400, "Project media not found.");
            }
            return response.badRequest(res, 500, "Error While fetching project media. Project media not found.");
        });
}

const getProjectNotes = async (req, res) => {

    if(!req.query.id){
        return response.badRequest(res, 500, "Please select any project to see the details. Please provide project reference id.");
    }
    Project.findById(req.query.id)
        .then(projectdata => {
            if (!projectdata) {
                return response.badRequest(res, 400, "Notes not found for project with id " + req.query.id);
            }
            console.log("rwspn", projectdata)
            //All good User has access to view project details
            return response.successResponse(res, 200, projectdata.notes, MESSAGE.PROJECT_NOTE_DATA);
        }).catch(err => {
            console.log("err", err)
            if (err.kind === 'ObjectId') {
                return response.badRequest(res, 400, "Project Notes not found.");
            }
            return response.badRequest(res, 500, "Error While fetching project notes. Project Notes not found.");
        });
}

const getProjectEstimatorAssistant = async (req, res) => {

    if(!req.query.id){
        return response.badRequest(res, 500, "Please select any project to see the details. Please provide project reference id.");
    }
    Project.findById(req.query.id)
        .then(projectdata => {
            if (!projectdata) {
                return response.badRequest(res, 400, "Estimator Assistant not found for project with id " + req.query.id);
            }
            console.log("rwspn", projectdata)
            //All good User has access to view project details
            return response.successResponse(res, 200, projectdata.associatedEstimatorAssistance, MESSAGE.PROJECT_ESTIMATOR_DATA);
        }).catch(err => {
            console.log("err", err)
            if (err.kind === 'ObjectId') {
                return response.badRequest(res, 400, "Project Estimator Assistant not found.");
            }
            return response.badRequest(res, 500, "Error While fetching project Estimator Assistant. Project Estimator Assistant not found.");
        });
}

const submitQuestion = async (req, res) => {
    try {
        const authHeader = req.headers.authorization;
        let token = authHeader.split("Bearer ")[1];
        const loggedInuser = await getLoggedInUser(token);
        const userId = loggedInuser.payload._id;
        const contractorDetails = await User.findOne({ _id: userId , deleted:false});
        const projectDetails = await Project.findOne({ _id: req.body.project_id});
        const rpcManagers = await User.find({ role: 'RPC_MANAGER', deleted:false})
        .select("-__v -createdAt -updatedAt -password -otp -mobile_no -phone_no -profile_pic -city -state -country -zip_code");
        var RPCManagersEmails = await rpcManagers.map(function (details) {
            return details['email'];
        });

        if(!projectDetails){
            return response.badRequest(res, 400, "Please check the project details. We are unable to reterive project details.");
        }
        const addQuesPayload = new QuestionAnswers(
            {
                question_text:req.body.question_text,
                created_by:userId,
                project_id:req.body.project_id,
            });
        addQuesPayload.save()
        .then(async data => {
            if (data){
                const emailData = {
                    msg: {
                      to: RPCManagersEmails, // all rpc managers emails
                      from: 'Winston@roofingprojects.com', // Use the email address or domain you verified above
                      template_id: EMAIL_TEMPLATES.NEW_QUESTION_SUBMIT_TEMPLATE_ID,
                      dynamic_template_data:{
                        "first_name":contractorDetails ? contractorDetails.first_name :"Guest User",
                        "last_name":contractorDetails ? contractorDetails.last_name :"Unregistered",
                        "project_name":projectDetails ? projectDetails.project_title : 'Project Details Not Available',
                        "question_text": req.body.question_text ? req.body.question_text : 'Question details not available.'
                    }
                    }
                  };
                  mail.sendMailWithTemplate(emailData);
                return response.successResponse(res, 200, data, MESSAGE.QUESTION_POSTED);
            }
            else{
                return response.badRequest(res, 400, MESSAGE.QUESTION_NOT_POSTED);
            }
        }).catch(err => {
            return res.status(500).send({
                message: err.message || "Some error occurred while creating the Template."
            });
        });
    } catch (e) {
        console.log(e)
        return response.somethingErrorMsgResponse(res, 500, e);
    }
}

const addAnswer = async (req, res) => {
    try {
        const authHeader = req.headers.authorization;
        let token = authHeader.split("Bearer ")[1];
        const loggedInuser = await getLoggedInUser(token);
        const userId = loggedInuser.payload._id;
        const questionDetails = await QuestionAnswers.findOne({ _id: req.body.questionId , deleted:false})
        .populate([{path:'created_by',select:['first_name', 'last_name', 'email']}]);
        if(!questionDetails){
            return response.badRequest(res, 400, "We are unable to reterive question details. Please check the question you have selected.");
        }
        const rpcManagers = await User.find({ role: 'RPC_MANAGER', deleted:false})
            .select("-__v -createdAt -updatedAt -password -otp -mobile_no -phone_no -profile_pic -city -state -country -zip_code");
        var RPCManagersEmails = await rpcManagers.map(function (details) {
                return details['email'];
            });
        const projectDetails = await Project.findOne({ _id: questionDetails.project_id })
        .populate([{path:'participating_bidders',select:['first_name', 'last_name', 'email']}]);
        var participatingBiddersEmails = await (projectDetails.participating_bidders).map(function (details) {
            return details['email'];
        });
        var senderEmails = [...participatingBiddersEmails , ...RPCManagersEmails] ;
        senderEmails.push(questionDetails.created_by.email);
        const payload = {
                answer_text:req.body.answer_text,
                replied_by:userId
            }
        const filter = {_id:req.body.questionId};
        let addReplyId = await QuestionAnswers.findOneAndUpdate(filter, {$set:payload},{new:true,upsert:false});
        if (addReplyId){
            
            const emailData = {
                msg: {
                  to: [...new Set(senderEmails)], // all rpc managers + bidders + question creator
                  from: 'Winston@roofingprojects.com', // Use the email address or domain you verified above
                  template_id: EMAIL_TEMPLATES.ANSWER_ADDED_TEMPLATE_ID,
                  dynamic_template_data:{
                    "project_name":projectDetails ? projectDetails.project_title : 'Project Details Not Available',
                    "question_text": questionDetails.question_text ? questionDetails.question_text : 'Question details not available.',
                    "answer_text": req.body.answer_text ? req.body.answer_text : 'Answer details not available.'
                    }
                }
              };
              mail.sendMailWithTemplate(emailData);
              return response.successResponse(res, 200, addReplyId, MESSAGE.ANSWER_POSTED);
        }
    else{
        return response.badRequest(res, 400, MESSAGE.ANSWER_NOT_POSTED);
    }
    } catch (e) {
        console.log("error", e)
        return response.somethingErrorMsgResponse(res, 500, e);
    }
}

const viewAllQuestionsAndAnswers = async (req, res) => {
    try {
        if(req.query.projectId && req.query.projectId !=''){
            const filter = { project_id: req.query.projectId };
            const result = await QuestionAnswers.find(filter).sort({createdAt:-1});
            if(result.length <= 0)
                return response.successResponse(res, 200,[], MESSAGE.LIST_OF_QUESTION_AND_ANSWER_NOT_FOUND);
            else
                return response.successResponse(res, 200, result, MESSAGE.LIST_OF_QUESTION_AND_ANSWER);
        }else{
                return response.somethingErrorMsgResponse(res, 500, 'Please provide the project reference. ');
        }
        
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
}

const getBiddenProjects = async (req, res) =>{
    try {
        const authHeader = req.headers.authorization;
        let token = authHeader.split("Bearer ")[1];
        const loggedInuser = await getLoggedInUser(token);
        const userId = loggedInuser.payload._id;

        let query = await db.checkQueryString(req.query)
        query.participating_bidders = { $in: [userId] } ;
        console.log("query", JSON.stringify(query))
        req.populate = [{
            path: 'buildingId',
            select: ['name','address','city','state','zip_code']
        },{
            path: 'ownerId',
            select: ['first_name', 'last_name', 'email','mobile','city','state','zip_code','street_address','profile_pic']
        },
        { path: 'media', match: { deleted: false } }];
        results = await db.getItems(req, Project, query);
        console.log("results", results)
        return response.successResponse(res, 200, await db.getItems(req, Project, query), MESSAGE.MY_BIDDEN_PROJECT_LIST);
        
        // let query = await db.checkQueryString(req.query);
        // query.submitted_by = userId ;
        // console.log("query", JSON.stringify(query))
        // req.populate = [
        //     {
        //         path: 'project_id',
        //         match:query,
        //         populate: ([{
        //             path: 'buildingId',
        //             select: ['name','address','city','state','zip_code']
        //         },{
        //             path: 'ownerId',
        //             select: ['first_name', 'last_name', 'email','mobile','city','state','zip_code','street_address','profile_pic']
        //         },
        //         { path: 'media', match: { deleted: false } }]),
        //     }
        // ]
        // return response.successResponse(res, 200, await db.getItems(req, projectBidSubmission, query), MESSAGE.PROJECT_VIEW_DATA);

        // const myBidDetails = await projectBidSubmission.find({ submitted_by: userId , })
        // .populate({
        //     path: 'project_id',
        //     match:query,
        //     populate: ([{
        //         path: 'buildingId',
        //         select: ['name','address','city','state','zip_code']
        //     },{
        //         path: 'ownerId',
        //         select: ['first_name', 'last_name', 'email','mobile','city','state','zip_code','street_address','profile_pic']
        //     },
        //     { path: 'media', match: { deleted: false } }]),
        // });
        // return response.successResponse(res, 200, myBidDetails, MESSAGE.MY_BIDDEN_PROJECT_LIST);
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
}

const closedProjects = async (req,res) => {
    try {
        let query = await db.checkQueryString(req.query)
        query.project_status = 'close';
        req.populate = [{ path: 'media', match: { deleted: false } }, { path: 'ownerId' }, { path: "buildingId" }, { path: "inspection" }]
        return response.successResponse(res, 200, await db.getItems(req, Project, query), MESSAGE.PROJECT_VIEW_DATA);
    } catch (error) {
        return response.somethingErrorMsgResponse(res, 500, error);
    }
}

const getPurchasedProjects = async (req, res) =>{
    try {
        const authHeader = req.headers.authorization;
        let token = authHeader.split("Bearer ")[1];
        const loggedInuser = await getLoggedInUser(token);
        const userId = loggedInuser.payload._id;
        const userData = await User.findOne({ _id: userId });
        console.log(userData.purchased_opportunities)
        const userPurchasedOpp = (userData.purchased_opportunities && userData.purchased_opportunities.length >0)? userData.purchased_opportunities : [];
        let query = await db.checkQueryString(req.query)
        query._id = { $in: userPurchasedOpp } ;
        console.log("query", JSON.stringify(query))
        req.populate = [{
            path: 'buildingId',
            select: ['name','address','city','state','zip_code']
        },{
            path: 'ownerId',
            select: ['first_name', 'last_name', 'email','mobile','city','state','zip_code','street_address','profile_pic']
        },
        { path: 'media', match: { deleted: false } }];
        results = await db.getItems(req, Project, query);
        console.log("results", results)
        return response.successResponse(res, 200, await db.getItems(req, Project, query), MESSAGE.MY_BIDDEN_PROJECT_LIST);
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
}

const getMyWonProjects = async (req, res) =>{
    try {
        const authHeader = req.headers.authorization;
        let token = authHeader.split("Bearer ")[1];
        const loggedInuser = await getLoggedInUser(token);
        const userId = loggedInuser.payload._id;
        const myWonBids = await projectBidSubmission.find({ submitted_by: userId , is_bid_winner : true , bid_status: 'CLOSED'});
        var wonProjects = await myWonBids.map(function (bids) {
            return bids['project_id'];
          });
        let query = await db.checkQueryString(req.query)
        query._id = { $in: wonProjects } ;
        console.log("wonProjects",wonProjects)
        req.populate = [{
            path: 'buildingId',
            select: ['name','address','city','state','zip_code']
        },{
            path: 'ownerId',
            select: ['first_name', 'last_name', 'email','mobile','city','state','zip_code','street_address','profile_pic']
        },
        { path: 'media', match: { deleted: false } }];
        results = await db.getItems(req, Project, query);
        console.log("results", results)
        return response.successResponse(res, 200, await db.getItems(req, Project, query), MESSAGE.MY_BIDDEN_PROJECT_LIST);
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
}

module.exports = {
    projectListByUsersLocation,
    addQuestions,
    addAnswer,
    viewAllQuestionsAndAnswers,
    searchProjects,
    getClosedProjects,
    searchClosedProjects,
    getProjects,
    submitQuestion,
    getProjectDetails,
    getProjectMedia,
    getProjectNotes,
    getProjectEstimatorAssistant,
    getBiddenProjects,
    closedProjects,
    getPurchasedProjects,
    getMyWonProjects
}