const response = require("../../constants/response");
const MESSAGE = require("../../constants/message");
const { Bid, Project,Media, Invitation, User } = require("../../models");
const mail = require("../../utils/notify");
const { consoleSandbox } = require("@sentry/utils");
const db = require("../../services/db");

// Mobile API Bid Form Bid prices adding in database
const bidForm = async (req,res) => {
  try {
      const obj = {contractor_id:req.id};
      const result  = await Bid.findOne(obj);
      const contractor  = obj.contractor_id
      const {LSBidPriceWords,LSBidPriceNumber,bidPrice,winningBidderPrice,totalBidPrice,unitPrice,alternateBidPriceWord,alternateBidPrice,
              alternateUnitPrice,company_name,company_description,project_Id} = req.body;
      const data  = await Bid.find({contractor_id:contractor,project_Id:project_Id});
      if (Array.isArray(data) && data.length > 0) {
          return response.conflictErrorMsgResponse(res, 409, MESSAGE.BID_ALREADY_DONE_ON_PROJECT);
        }
      const bidData = new Bid({LSBidPriceWords,LSBidPriceNumber,bidPrice,unitPrice,winningBidderPrice,totalBidPrice,alternateBidPriceWord,
          alternateBidPrice,alternateUnitPrice,company_name,company_description,project_Id, contractor_id: contractor});
      const saveBidData = await bidData.save();
      let media = [];
      if (req?.files?.contractor_docs) {
          req.files.contractor_docs.forEach((element) => {
              media.push({ path: element.path, filename: element.filename, ref_id: saveBidData._id, type: "contractor_docs" });
          });
      }
      await Media.insertMany(media);
      let results = await db.getItemByParams(Bid, { _id: saveBidData._id }, [{path: "media"},{path:"project_Id"},{path:"contractor_id"}])
      if(results){
          const projectTitle = results.project_Id.project_title
          const email = results.contractor_id.email;
          let subject = "Bid Confirmaition";
          let text = `You have successfully placed bid for the project <h3>${projectTitle}</h3>`;
          mail.sendMail(email, subject, text);
     return response.successResponse(res, 200, results, MESSAGE.BID_DATA_ADD_SUCCESS);
      }
  } catch (e) {
      return response.somethingErrorMsgResponse(res, 500, e);
  }
}
// Mobile API Edit Bid Form. Bid Data edits in database
const editBidForm = async (req,res) => {
  try {
      const {LSBidPriceWords,LSBidPriceNumber,bidPrice,winningBidderPrice,totalBidPrice,unitPrice,alternateBidPriceWord,alternateBidPric,
          alternateUnitPrice,company_name,company_description} = req.body;
      const filter = {$and:[{contractor_id:req.id},{project_Id:req.body.project_id}]}
      const update = {LSBidPriceWords:LSBidPriceWords,LSBidPriceNumber:LSBidPriceNumber,bidPrice:bidPrice,winningBidderPrice:winningBidderPrice,
          totalBidPrice:totalBidPrice,unitPrice:unitPrice,alternateBidPriceWord:alternateBidPriceWord,alternateBidPric:alternateBidPric,
          alternateUnitPrice:alternateUnitPrice,company_name:company_name,company_description:company_description}
      const data  = await Bid.findOneAndUpdate(filter,update,{ new: true }).exec();
      if(data)
      return response.successResponse(res, 200, data, MESSAGE.BID_UPDATE_SUCCESS);
      else
      return response.badRequest(res, 400, MESSAGE.BID_NOT_FOUND);
  } catch(e) {
      return response.somethingErrorMsgResponse(res, 500, e);
  }
}
// Mobile API List of Bidden Projects
const biddenprojects = async (req, res) => {
  try {
      const obj = { contractor_id: req.id };
      const result = await Bid.find(obj);
      let arr = [];
      result.forEach(element => {
          arr.push(element.project_Id);
      });
      const biddenProjects = await Project.find({ '_id': { $in: arr } })
          .populate([{ path: 'media' }, { path: 'buildingId' }, { path: 'ownerId' }]);
      if(biddenProjects.length <= 0) 
          return response.successResponse(res, 200,{}, MESSAGE.BIDDEN_PROJECT_NOT_FOUND);
      else
          return response.successResponse(res, 200, biddenProjects, MESSAGE.BIDDEN_PROJECT_VIEW_DATA);
  } catch (error) {
      return response.somethingErrorMsgResponse(res, 500, error);
  }
}
//Mobile API Searches Bidden Project List by Title
const searchBiddenProjects = async (req, res) => {
    try {
        const obj = { contractor_id: req.id };
        const result = await Bid.find(obj);
        let arr = [];
        result.forEach(element => {
            arr.push(element.project_Id);
        });
        let payload = req.query.payload.trim();
        let biddenProjects = await Project.find({ '_id': { $in: arr, }, "project_title": { $regex: '^.*' + payload, $options: 'i' } })
            .populate([{ path: 'media' }, { path: 'buildingId' }, { path: 'ownerId' }]);
        biddenProjects = biddenProjects.slice(0, 10);
        if(biddenProjects.length <= 0)
            return response.successResponse(res, 200,{}, MESSAGE.PROJECT_NOT_FOUND);
        else
            return response.successResponse(res, 200, {payload: biddenProjects}, MESSAGE.PROJECT_VIEW_DATA);
    } catch (error) {
        return response.somethingErrorMsgResponse(res, 500, error);
    }
}
// Mobile API gets list of woned Bidden Projects of contractor
const winningBidProjects = async (req, res) => {
    try {
        const result = await Bid.find({ contractor_id: req.id, is_bid_winner: true });
        let arr = [];
        result.forEach(element => {
            arr.push(element.project_Id);
        });
        const winningProjects = await Project.find({ '_id': { $in: arr } })
            .populate([{ path: 'media' }, { path: 'buildingId' }, { path: 'ownerId' }]);
        if(winningProjects.length <= 0) 
            return response.successResponse(res, 200,{}, MESSAGE.WINNING_PROJECT_NOT_FOUND);
        else
            return response.successResponse(res, 200, winningProjects, MESSAGE.CONTRACTOR_WONED_PROJECTS);
    } catch (error) {
        return response.somethingErrorMsgResponse(res, 500, error);
    }
}
// Mobile API for searching winning projects
const searchWonProjects = async (req,res) => {
    try {
        const result = await Bid.find({ contractor_id: req.id, is_bid_winner: true });
        let arr = [];
        result.forEach(element => {
            arr.push(element.project_Id);
        });
        let payload = req.query.payload.trim();
        let search = await Project.find({ '_id': { $in: arr }, "project_title": { $regex: '^.*' + payload, $options: 'i' }})
            .populate([{ path: 'media' }, { path: 'buildingId' }, { path: 'ownerId' }]);
        search = search.slice(0, 10);
        if(search.length <= 0)
            return response.successResponse(res, 200,{}, MESSAGE.WINNING_PROJECT_NOT_FOUND);
        else
            return response.successResponse(res, 200, {payload:search}, MESSAGE.CONTRACTOR_WONED_PROJECTS);
    } catch (error) {
        return response.somethingErrorMsgResponse(res, 500, error);
    }
}
/**
 * 
 * @param {Object} req -loggedIn User, BidId
 * @param {Object} res 
 * @returns Bid info
 */
const getBidInfoById = async (req,res) => {
    try {
            let result = await Bid.find({$and:[{contractor_id:req.id},{project_Id:req.query.projectId}]})
            if(result <= 0)
                return response.successResponse(res, 200,{}, MESSAGE.BIDDEN_PROJECT_NOT_FOUND)  
            else
                return response.successResponse(res, 200, result, MESSAGE.BIDDEN_PROJECT_VIEW_DATA)
        } catch(error) {
        return response.somethingErrorMsgResponse(res, 500, error);
    }
}
const getInvitationList = async (req,res) => {
    try {
        const user = await User.findOne({_id:req.id});
        const result = await Invitation.find({$and:[{contarctor_email:user.email},{bid_acceptance:false}]})
        .populate([{path:'createdBy'},{path:'project_Id'}]);
        if(result.length <= 0)
            return response.successResponse(res, 200,{}, MESSAGE.PROJECT_NOT_FOUND);
        else
            return response.successResponse(res, 200, result, MESSAGE.PROJECT_VIEW_DATA);
    } catch(error) {
        return response.somethingErrorMsgResponse(res, 500, error);
    }
}

const acceptBidInvitation = async (req,res) => {
    try {
        let filter = { _id: req.query.id };
        let update = {"$set":{ bid_acceptance:true}};
        let isAccepted = await Invitation.findOne(filter);
        if(isAccepted.bid_acceptance == true)
        return response.successResponse(res, 200, {}, MESSAGE.BID_ACCEPTED_ALREADY);
        const result = await Invitation.findOneAndUpdate(filter,update,{new:true});
        if(result)
            return response.successResponse(res, 200, result, MESSAGE.BID_INVITATION_ACCEPTED);
        else
            return response.successResponse(res, 200,{}, MESSAGE.BID_INVITATION_REJECTED);
    } catch(error) {
        return response.somethingErrorMsgResponse(res, 500, error);
    }
}

module.exports = {
  bidForm,
  editBidForm,
  biddenprojects,
  searchWonProjects,
  winningBidProjects,
  searchBiddenProjects,
  getBidInfoById,
  getInvitationList,
  acceptBidInvitation
};
