/*
    This is authentication controller for all types of user authentication 
*/
const date = require("date-and-time");
const jwt = require("jsonwebtoken");
const bcrypt = require("bcryptjs");
const saltRounds = 10;
const mail = require("../utils/notify");
const verify = require("../utils/verifyEmailAndOtp");
const { getJwtToken } = require("../utils/jwtToken");
const { _number } = require("../utils/getRandom");
const { User} = require("../models/");
const response = require("../constants/response");
const MESSAGE = require("../constants/message");
const db = require("../services/db");
const { _value } = require("../utils/getRandom");

// Mobile API Forget Password
const forgetPassword = async (req, res) => {
  try {
    const {email} = req.body;
    let userData = await User.findOne({email: email});
    if (userData) {
      const otp = _number(1, 999999);
      const filter = {_id: userData._id};
      const update = {otp:otp};
      let result = await User.findOneAndUpdate(filter,update,{new:true});
      console.log(result.otp);
      let subject = "OTP for forget password";
      let text = `hi ${email} <br> your OTP is: ${result.otp}.<br>Use this OTP to verify your email`;
      mail.sendMail(email, subject, text);
      response.successResponse(res, 200, MESSAGE.OTP_SENT_ON_EMAIL);
    } 
    else
      response.somethingErrorMsgResponse(res, 500, MESSAGE.EMAIL_NOT_FOUND);
  } catch (error) {
    response.somethingErrorMsgResponse(res, 301, MESSAGE.SOMETHING_WENT_WRONG);
  }
};
// Mobile API Verify Email and OTP
const verifyEmail = async (req, res) => {
  try {
    const {email, otp} = req.body;
    const result = await User.findOne({email: email});
    if (result.otp != otp)
      response.somethingErrorMsgResponse(res, 403, MESSAGE.OTP_ERROR);
    else
      response.successResponse(res, 200, MESSAGE.EMAIL_VERIFIED);
  } catch (error) {
    response.somethingErrorMsgResponse(res, 301, MESSAGE.SOMETHING_WENT_WRONG);
  }
}
// Mobile API Reset Password
const resetPassword = async (req, res) => {
  try {
    const {email, password} = req.body;
    if(email) {
      let userData = await User.findOne({email: email});
      if(userData) {
        bcrypt.genSalt(saltRounds, function (err, salt) {
          bcrypt.hash(password, salt, function (err, hash) {
            verify.updateWithObject(User,{email: email},{password: hash, otp: null});
          });
        });
        if(userData.otp == null)
          response.somethingErrorMsgResponse(res, 301, MESSAGE.OTP_IS_NULL);
        else
          response.successResponse(res, 200, MESSAGE.PASSWORD_UPDATE_SUCCESS);
      } 
      else 
        response.somethingErrorMsgResponse(res,301,MESSAGE.PASSWORD_UPDATE_FAILURE);
    }
  } catch (error) {
    response.somethingErrorMsgResponse(res, 301, MESSAGE.SOMETHING_WENT_WRONG);
  }
};

// API for edits user profile
const updateUserById = async (req, res) => {
  const { id } = req;
  try {
    let results = await db.updateItem(id, User, req.body)
    results = await db.getItemByParams(User, { _id: results._id });
    return response.successResponse(res, 200, results, MESSAGE.USER_UPDATE_SUCCESS);
  } catch (error) {
    return response.somethingErrorMsgResponse(res, 500, error);
  }
}
// API edits user profile picture
const updateProfilePicture = async (req, res) => {
  try {
    let profileImg = [];
    if (req?.files?.profile_pic) {
      req.files.profile_pic.forEach((element) => {
        profileImg.push({ path: "public/uploads/" + element.filename, filename: element.filename, type: "profile_pic" });
      });
    }
    const filter = { _id: req.id };
    const update = { profile_pic: profileImg };
    const userData = await User.findOneAndUpdate(filter, update, { upsert: true, new: true }).exec();
    return response.successResponse(res, 200, userData.profile_pic, MESSAGE.USER_PROFILE_PIC_UPDATED);
  } catch (error) {
    return response.somethingErrorMsgResponse(res, 500, error);
  }

}

module.exports = {
  resetPassword,
  forgetPassword,
  verifyEmail,
  updateUserById,
  updateProfilePicture
};
