const {User} = require('../models/')

const email = async (req,res,next) => {
    
}

module.exports = {
    /**
     * Checks User model if user with an specific email exists
     * @param {string} email - user email
     */
    async emailExists(obj) {
      return new Promise((resolve, reject) => {
        User.findOne(
          { $or: [{ email: obj.email }, { phone: obj.phone }] },
          (err, item) => {
            itemAlreadyExists(err, item, reject, 'EMAIL_ALREADY_EXISTS')
            resolve(false)
          }
        )
      })
    }
}


/**
 * Item already exists
 * @param {Object} err - error object
 * @param {Object} item - item result object
 * @param {Object} reject - reject object
 * @param {string} message - message
 */
 exports.itemAlreadyExists = (err, item, reject, message) => {
    if (err) {
      reject(exports.buildErrObject(422, err.message));
    }
    if (item) {
      reject(exports.buildErrObject(422, message));
    }
  };

  /**
 * Builds error object
 * @param {number} code - error code
 * @param {string} message - error text
 */
exports.buildErrObject = (code, message) => {
    return {
      code,
      message
    };
  };
  