const jwt = require("jsonwebtoken");
const response = require("../constants/response");
const MESSAGE = require("../constants/message");
require("dotenv").config();


const verify = (req, res, next) => {
    const authHeader = req.headers.authorization;
    if (authHeader && req.headers.authorization.includes("Bearer ")) {
        let token = authHeader.split("Bearer ")[1];
        jwt.verify(token, process.env.TOKEN_SECRET, (err, decoded) => {
            if (err) {
                return response.somethingErrorMsgResponse(
                    res,
                    403,
                    MESSAGE.TOKEN_ERROR
                );
            } else {
                //    set user id and role globally
                req.id = decoded._id;
                req.role_name = decoded._role_name;
                next();
            }
        });

    } else {
        return response.somethingErrorMsgResponse(
            res,
            400,
            MESSAGE.UNAUTHORIZED
        );
    }
}

module.exports = { verify };