const { MANUFACTURER, CONTRACTOR, RPC_MANAGER, OWNER } = require("../constants/roles");
const response = require("../constants/response");
const MESSAGE = require("../constants/message");

/*
1. Make sure only MANUFACTURER and CONTRACTOR can signup through signup api
*/
const validateSignupRole = (req, res, next) => {
  const { role } = req.body;
  switch (role) {
    case MANUFACTURER:
      next();
      break;
    case CONTRACTOR:
      next();
      break;
    case RPC_MANAGER:
      next();
      break;
    case OWNER:
      next();
      break;
    default:
      return response.errorMessageResponse(res, 505, MESSAGE.INVALID_ROLE);
  }
};

module.exports = {
  validateSignupRole,
};
