const { Session } = require("../models");
const response = require("../constants/response");
const MESSAGE = require("../constants/message");

const isSessionActive = async (req, res, next) => {
  const id = req.id;
  try {
    const session = await Session.findOne({ user_id: id }).exec();
    if (session.is_active) {
      next();
    } else {
      return response.somethingErrorMsgResponse(res, 400, MESSAGE.UNAUTHORIZED);
    }
  } catch (e) {
    return response.somethingErrorMsgResponse(res, 400, MESSAGE.UNAUTHORIZED);
  }
};
module.exports = {
  isSessionActive,
};
