const { User, Role} = require('../models');
const response = require('../constants/response');
const MESSAGE = require('../constants/message');

const admin = (req, res, next) => {
    const ROLE = req.role_name;
    if (ROLE == "ADMIN") {
        next();
    } else {
        return response.somethingErrorMsgResponse(
            res,
            400,
            MESSAGE.DONT_HAVE_PERMISSION
        );
    }
}

const active = (req, res, next) => {
    USER_ID = req.id;
    USER_EMAIL = req.body.email;
    // console.log(USER_ID);
    User.findOne({ 
        $or: [{
            _id: USER_ID
        },
        {
            email: USER_EMAIL
        }
    ],
    }, function (err, user) {
        if (user) {
            next();
        } else {
            return response.errorMessageResponse(res, 403, MESSAGE.NOT_ACTIVE);
        }
    });
}
const rpcManager = async (req,res,next) => {
    const ROLE = req.role_name;
    if (ROLE == "RPC_MANAGER") {

        next();
    } else {
        return response.somethingErrorMsgResponse(
            res,
            400,
            MESSAGE.DONT_HAVE_PERMISSION
        );
    }
}
const contractor = (req,res,next) => {
    const ROLE = req.role_name;
    if (ROLE == "CONTRACTOR") {
        next();
    } else {
        return response.somethingErrorMsgResponse(
            res,
            400,
            MESSAGE.DONT_HAVE_PERMISSION
        );
    }
}

const owner = (req,res,next) => {
    const ROLE = req.role_name;
    if (ROLE == "OWNER") {
        next();
    } else {
        return response.somethingErrorMsgResponse(
            res,
            400,
            MESSAGE.DONT_HAVE_PERMISSION
        );
    }
}

const manufacturer = (req,res,next) => {
    const ROLE = req.role_name;
    if (ROLE == "MANUFACTURER") {
        next();
    } else {
        return response.somethingErrorMsgResponse(
            res,
            400,
            MESSAGE.DONT_HAVE_PERMISSION
        );
    }
}

module.exports = {
    admin,
    rpcManager,
    contractor,
    owner,
    active,
    manufacturer
}