const { User } = require("../models");
const response = require("../constants/response");
const MESSAGE = require("../constants/message");

const hasPermission = async (req, res, next) => {
  const USER_ID = req.id;
  const PATH = req.path;
  const PATH_SPLITS = PATH.split("/");
  const route = PATH_SPLITS[1];
  const action = PATH_SPLITS[2];
  let userdetails = null;
  switch (action) {
    case 'create':
      userdetails = await User.findOne({
        _id: USER_ID,
        permissions: {
          "$elemMatch": {
            "route": route,
            "create": true,
          }
        }
      });
      break;
    case 'view':
      userdetails = await User.findOne({
        _id: USER_ID,
        permissions: {
          "$elemMatch": {
            "route": route,
            "view": true,
          }
        }
      });
      break;
    case 'update':
      userdetails = await User.findOne({
        _id: USER_ID,
        permissions: {
          "$elemMatch": {
            "route": route,
            "update": true,
          }
        }
      });
      break;
    case 'delete':
      userdetails = await User.findOne({
        _id: USER_ID,
        permissions: {
          "$elemMatch": {
            "route": route,
            "delete": true,
          }
        }
      });
      break;
    default:
      return response.somethingErrorMsgResponse(res, 500, {});
  }
  if (userdetails !== null) {
    next();
  } else {
    return response.errorMessageResponse(res, 403, MESSAGE.DONT_HAVE_PERMISSION);
  }
}

module.exports = {
  hasPermission
}

