const { check, validationResult } = require('express-validator');
const message = require('../constants/message');
const response = require('../constants/response');

/**
 * Validates create new user request
 */
exports.signup = [
  check('first_name')
    .exists()
    .withMessage('MISSING')
    .not()
    .isEmpty()
    .withMessage(message.IS_EMPTY),
  check('last_name')
    .exists()
    .withMessage('MISSING')
    .not()
    .isEmpty()
    .withMessage(message.IS_EMPTY),
  check('email')
    .exists()
    .withMessage('MISSING')
    .not()
    .isEmpty()
    .withMessage(message.IS_EMPTY)
    .isEmail()
    .withMessage(message.EMAIL_NOT_VALID),
  // check('password')
  //   .exists()
  //   .withMessage('MISSING')
  //   .not()
  //   .isEmpty()
  //   .withMessage(message.IS_EMPTY)
  //   .isLength({
  //     min: 5
  //   })
  //   .withMessage('PASSWORD_TOO_SHORT_MIN_5'),
  check('company_name')
    .exists()
    .withMessage('MISSING')
    .not()
    .isEmpty()
    .withMessage(message.IS_EMPTY)
    .trim(),
  check('mobile_no')
    .exists()
    .withMessage('MISSING')
    .not()
    .isEmpty()
    .withMessage(message.IS_EMPTY)
    .trim(),
  check('city')
    .exists()
    .withMessage('MISSING')
    .not()
    .isEmpty()
    .withMessage(message.IS_EMPTY)
    .trim(),
  check('state')
    .exists()
    .withMessage('MISSING')
    .not()
    .isEmpty()
    .withMessage(message.IS_EMPTY)
    .trim(),
  (req, res, next) => {
    const errors = validationResult(req);
    if (!errors.isEmpty()) {
      return response.errorMessageResponse(res, 406, errors.array());
    } else {
      next();
    }
  }
]


/**
 * Validates Login new user request
 */
exports.login = [
  check('email')
    .exists()
    .withMessage('MISSING')
    .not()
    .isEmpty()
    .withMessage(message.IS_EMPTY)
    .isEmail()
    .withMessage(message.EMAIL_NOT_VALID),
  check('password')
    .exists()
    .withMessage('MISSING')
    .not()
    .isEmpty()
    .withMessage(message.IS_EMPTY)
    .isLength({
      min: 5
    })
    .withMessage('PASSWORD_TOO_SHORT_MIN_5'),
  (req, res, next) => {
    const errors = validationResult(req);
    if (!errors.isEmpty()) {
      return response.errorMessageResponse(res, 406, errors.array());
    } else {
      next();
    }
  }
]

/**
 * Validates forgetPassword new user request
 */
exports.forgetPassword = [
  check('email')
    .exists()
    .withMessage('MISSING')
    .not()
    .isEmpty()
    .withMessage(message.IS_EMPTY)
    .isEmail()
    .withMessage(message.EMAIL_NOT_VALID),
  (req, res, next) => {
    const errors = validationResult(req);
    if (!errors.isEmpty()) {
      return response.errorMessageResponse(res, 406, errors.array());
    } else {
      next();
    }
  }
]

/**
 * Validates reset password request
 */
exports.resetPassword = [
  check("password")
    .exists()
    .withMessage("MISSING")
    .not()
    .isEmpty()
    .withMessage(message.IS_EMPTY)
    .isLength({
      min: 5
    })
    .withMessage("PASSWORD_TOO_SHORT_MIN_5"),
  (req, res, next) => {
    const errors = validationResult(req);
    if (!errors.isEmpty()) {
      return response.errorMessageResponse(res, 406, errors.array());
    } else {
      next();
    }
  }
];