const response = require("../../constants/response");
const MESSAGE = require("../../constants/message");
const { WindUplift } = require("../../models");
const db = require("../../services/db");

/**
* Creates a new WindUplift in database
* @param {Object} req - request object
*/
const add = async (req, res) => {
    const {
        wind_uplift_name,
        description
    } = req.body;
    try {
        if (await WindUplift.findOne({ "wind_uplift_name": new RegExp(wind_uplift_name.replace(/\\|\s+/g, ' ').trim(), 'i') })) {
            return response.badRequest(res, 404, MESSAGE.DUPLICATE_Wind_Uplift);
        } else {
            const windUplift = new WindUplift({
                wind_uplift_name,
                description
            });
            const SaveWindUplift = await windUplift.save();
            return response.successResponse(res, 200, SaveWindUplift, MESSAGE.Wind_Uplift_ADD_SUCCESS);
        }
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
}

/**
 * Updates an WindUplift in database by id
 * @param {string} id - item id
 * @param {Object} req - request object
 */
const update = async (req, res) => {
    const {
        wind_uplift_name,
        description
    } = req.body;
    try {
        var result = await WindUplift.findByIdAndUpdate(
            (_id = req.body._id),
            {
                wind_uplift_name,
                description
            }
        );
        if (result) {
            return response.successResponse(res, 200, result, MESSAGE.Wind_Uplift_UPDATE_SUCCESS);
        } else {
            return response.badRequest(res, 400, MESSAGE.Wind_Uplift_NOT_FOUND);
        }
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
}

/**
* Get All Material from database by role
* @param {string} req - object
*/
const viewAll = async (req, res) => {
    try {
        let query = await db.checkQueryString(req.query)
        return response.successResponse(res, 200, await db.getItems(req, WindUplift, query), MESSAGE.Wind_Uplift_VIEW_DATA);
    } catch (error) {
        console.log(error);
        return response.somethingErrorMsgResponse(res, 500, error);
    }
}

/**
* toggle change for WindUplift status from database by id
* @param {string} id - user id
*/
const updateWindUpliftStatus = (req, res) => {
    const wind_uplift_id = req.body.id;
    WindUplift.findOne({ _id: wind_uplift_id }, (err, windUplift) => {
        windUplift.status = !windUplift.status;
        windUplift.save((err, updatedWindUplift) => {
            if (!err) {

                return response.successResponse(res, 200, { status: windUplift.status }, MESSAGE.Wind_Uplift_STATUS_UPDATED);
            } else {
                return response.somethingErrorMsgResponse(res, 500, error);
            }
        });
    });
}

/**
* Delete one WindUplift from database by id
* @param {string} id - user id
*/
const deleteWindUplift = async (req, res) => {
    try {
        const result = await db.softDeleteItems(req.params.id, WindUplift)
        if (result) {
            return response.successResponse(res, 200, {}, MESSAGE.Wind_Uplift_DELETE_SUCCESS);
        } else {
            return response.somethingErrorMsgResponse(res, 500, MESSAGE.SOMETHING_WENT_WRONG);
        }
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
}

/**
 * Get one WindUplift from database by id
 * @param {string} id -  id
 */
const viewOne = async (req, res) => {
    const Wind_Uplift_Id = req.query.id;
    try {
        const result = await WindUplift.findOne({ _id: Wind_Uplift_Id }).exec();
        return response.successResponse(res, 200, result);
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
};

module.exports = {
    viewAll,
    viewOne,
    add,
    updateWindUpliftStatus,
    update,
    deleteWindUplift
}