const { Transaction } = require("../../models");
const response = require("../../constants/response");
const MESSAGE = require("../../constants/message");
const db = require('../../services/db')

const getAllTransactions = async (req, res) => {
    try {
        let query = await db.checkQueryString(req.query);
        return response.successResponse(res, 200, await db.getItems(req, Transaction, query), "transactions fetched successfully.");
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, error);
    }
}
const getAllTransactionByPorjectId = async (req, res) => {
    try {
        let query = await db.checkQueryString(req.query);
        return response.successResponse(res, 200, await db.getItemsByParams(Transaction, query), "transactions fetched successfully.");
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, error);
    }
}
const createTransaction = async (req, res) => {
    try {
        const payload = { ...req.body };
        return response.successResponse(res, 200, await db.insertItem(Transaction, payload), "transactions creted successfully.");
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, error);
    }
}
module.exports = { getAllTransactions, getAllTransactionByPorjectId, createTransaction }