const response = require("../../constants/response");
const MESSAGE = require("../../constants/message");
const { Terms } = require("../../models");
const db = require("../../services/db");

/**
* Creates a new TERM  in database
* @param {Object} req - request object
*/
const add = async (req, res) => {
    const { title, detail, status } = req.body;
    // Validate user input
    if (!title) {
        return response.badRequest(res, 400, MESSAGE.TERM_TITLE_EMPTY_ERROR);
    }
    if (!detail) {
        return response.badRequest(res, 400, MESSAGE.TERM_DETAIL_EMPTY_ERROR);
    }
    const term = new Terms({
        title,
        detail,
        status
    });
    try {
        const saveTerm = await term.save();
        return response.successResponse(
            res,
            200,
            saveTerm,
            MESSAGE.TERM_ADD_SUCCESS
        );
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
};

const viewAll = async (req, res) => {
    try {
        let query = await db.checkQueryString(req.query)
        console.log(await db.getItems(req, Terms, query));
        return response.successResponse(res, 200, await db.getItems(req, Terms, query), MESSAGE.TERM_VIEW_DATA);
    } catch (error) {
        console.log(error)
        return response.somethingErrorMsgResponse(res, 500, error);
    }
}

const update = async (req, res) => {
    const { title, detail, status } = req.body;

    if (!title) {
        return response.badRequest(res, 400, MESSAGE.TERM_TITLE_EMPTY_ERROR);
    }
    if (!detail) {
        return response.badRequest(res, 400, MESSAGE.TERM_DETAIL_EMPTY_ERROR);
    }

    try {
        const result = await Terms.findByIdAndUpdate(
            (_id = req.body._id),
            {
                title,
                detail,
                status
            },
            { new: true }
        );

        if (result) {
            return response.successResponse(
                res,
                200,
                result,
                MESSAGE.TERM_UPDATE_SUCCESS
            );
        } else {
            return response.badRequest(res, 400, MESSAGE.TERM_NOT_FOUND);
        }
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
};

const deleteTerm = async (req, res) => {
    try {
        const result = await db.softDeleteItems(req.params.id, Terms)
        if (result) {
            return response.successResponse(res, 200, {}, MESSAGE.TERM_DELETE_SUCCESS);
        } else {
            return response.somethingErrorMsgResponse(res, 500, MESSAGE.SOMETHING_WENT_WRONG);
        }
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
};

module.exports = { add, viewAll, update, deleteTerm }